/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.lep.impl;

import com.icthh.xm.commons.lep.api.LepKey;
import com.icthh.xm.commons.logging.config.LoggingConfig;
import com.icthh.xm.commons.logging.config.LoggingConfigService;
import com.icthh.xm.commons.logging.util.LogObjectPrinter;
import com.icthh.xm.lep.api.LepMethod;
import com.icthh.xm.lep.api.MethodSignature;
import java.util.Optional;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingWrapper {
    private static final Logger log = LoggerFactory.getLogger(LoggingWrapper.class);
    private static final String LOG_QUESTION = "?";
    private static final String LOG_SEMICOLON = ":";
    private static final String LOG_START_PATTERN = "lep:start: execute lep at [{}], script: {}";
    private static final String LOG_STOP_PATTERN = "lep:stop:  execute lep at [{}], script: {}";
    private static final String LOG_ERROR_PATTERN = "lep:stop:  execute lep error at [{}], script: {}, error: {}";
    private final LoggingConfigService loggingConfigService;

    public <T> T doWithLogs(LepMethod lepMethod, String scriptName, LepKey lepKey, Callable<T> task) throws Exception {
        String methodSignature = LoggingWrapper.buildLepSignature(lepMethod);
        try {
            this.logStart(methodSignature, scriptName);
            T result = task.call();
            this.logStop(methodSignature, scriptName);
            return result;
        }
        catch (Throwable e) {
            this.logStopError(methodSignature, scriptName, e);
            throw e;
        }
    }

    private void logStart(String methodSignature, String scriptName) {
        LoggingConfig.LepLogConfiguration loggingConfig = this.loggingConfigService.getLepLoggingConfig(scriptName);
        if (loggingConfig == null) {
            log.info(LOG_START_PATTERN, (Object)methodSignature, (Object)scriptName);
            return;
        }
        if (LogObjectPrinter.Level.OFF_LOG.equals((Object)loggingConfig.getLevel())) {
            return;
        }
        LogObjectPrinter.logWithLevel((Logger)log, (LogObjectPrinter.Level)loggingConfig.getLevel(), (String)LOG_START_PATTERN, (Object[])new Object[]{methodSignature, scriptName});
    }

    private void logStop(String signature, String scriptName) {
        LoggingConfig.LepLogConfiguration config = this.loggingConfigService.getLepLoggingConfig(scriptName);
        if (config == null) {
            log.info(LOG_STOP_PATTERN, (Object)signature, (Object)scriptName);
            return;
        }
        if (LogObjectPrinter.Level.OFF_LOG.equals((Object)config.getLevel())) {
            return;
        }
        LogObjectPrinter.logWithLevel((Logger)log, (LogObjectPrinter.Level)config.getLevel(), (String)LOG_STOP_PATTERN, (Object[])new Object[]{signature, scriptName});
    }

    private void logStopError(String signature, String scriptName, Throwable e) {
        log.error(LOG_ERROR_PATTERN, new Object[]{signature, scriptName, LogObjectPrinter.printExceptionWithStackInfo((Throwable)e)});
    }

    private static String buildLepSignature(LepMethod method) {
        String className = Optional.ofNullable(method).map(LepMethod::getMethodSignature).map(MethodSignature::getDeclaringClass).map(Class::getSimpleName).orElse(LOG_QUESTION);
        String methodName = Optional.ofNullable(method).map(LepMethod::getMethodSignature).map(MethodSignature::getName).orElse(LOG_QUESTION);
        return className + LOG_SEMICOLON + methodName;
    }

    public LoggingWrapper(LoggingConfigService loggingConfigService) {
        this.loggingConfigService = loggingConfigService;
    }
}

