/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.lep.spring.lepservice;

import com.icthh.xm.commons.lep.LogicExtensionPoint;
import com.icthh.xm.commons.lep.spring.LepService;
import com.icthh.xm.commons.lep.spring.lepservice.LepServiceFactoryResolver;
import com.icthh.xm.commons.logging.aop.IgnoreLogginAspect;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang3.time.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

@IgnoreLogginAspect
@LepService(group="service.factory")
public class LepServiceFactoryWithLepFactoryMethod {
    private static final Logger log = LoggerFactory.getLogger(LepServiceFactoryWithLepFactoryMethod.class);
    private final Integer timeout;
    private final Map<String, Map<String, Class<?>>> classCache = new ConcurrentHashMap();
    private final Map<String, Map<Class<?>, Object>> serviceInstances = new ConcurrentHashMap();
    private final Map<String, Map<Class<?>, Lock>> serviceLocks = new ConcurrentHashMap();
    private LepServiceFactoryWithLepFactoryMethod self;

    public LepServiceFactoryWithLepFactoryMethod(@Value(value="${application.lep.service-factory-timeout:60}") Integer timeout) {
        this.timeout = timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T getInstance(String scopeId, Class<T> lepServiceClass) {
        String simpleClassName = lepServiceClass.getSimpleName();
        Map tenantInstances = this.serviceInstances.computeIfAbsent(scopeId, key -> new ConcurrentHashMap());
        Object instance = tenantInstances.get(lepServiceClass);
        if (instance != null) {
            return (T)instance;
        }
        Map tenantServiceFactoryLocks = this.serviceLocks.computeIfAbsent(scopeId, key -> new ConcurrentHashMap());
        Lock lock = tenantServiceFactoryLocks.computeIfAbsent(lepServiceClass, key -> new ReentrantLock());
        StopWatch stopWatch = StopWatch.createStarted();
        log.trace("Try to acquired lock for service {}", (Object)lepServiceClass.getCanonicalName());
        if (!lock.tryLock(this.timeout.intValue(), TimeUnit.SECONDS)) {
            throw new IllegalStateException(String.format("Timeout waiting service factory for service %s.", lepServiceClass.getCanonicalName()));
        }
        try {
            log.trace("Successfully acquired lock for service {} in {}ns", (Object)lepServiceClass.getSimpleName(), (Object)stopWatch.getNanoTime());
            instance = tenantInstances.get(lepServiceClass);
            if (instance != null) {
                Object v = instance;
                return (T)v;
            }
            T newInstance = this.self.createServiceByLepFactory(simpleClassName, lepServiceClass);
            tenantInstances.put(lepServiceClass, newInstance);
            T t = newInstance;
            return t;
        }
        finally {
            lock.unlock();
            log.trace("Lock for service {} successfully released in {}ns", (Object)lepServiceClass.getSimpleName(), (Object)stopWatch.getNanoTime());
            tenantServiceFactoryLocks.remove(lepServiceClass);
        }
    }

    @LogicExtensionPoint(value="ServiceFactory", resolver=LepServiceFactoryResolver.class)
    public <T> T createServiceByLepFactory(String serviceClassName, Class<T> type) {
        return this.self.createServiceByGeneratedLepFactory(serviceClassName, type);
    }

    @LogicExtensionPoint(value="GeneratedServiceFactory")
    public <T> T createServiceByGeneratedLepFactory(String serviceClassName, Class<T> type) {
        throw new RuntimeException("Error with service factory generation " + serviceClassName);
    }

    @Autowired
    public void setSelf(LepServiceFactoryWithLepFactoryMethod self) {
        this.self = self;
    }

    public void clear(String scopeId) {
        this.classCache.remove(scopeId);
        this.serviceInstances.remove(scopeId);
        this.serviceLocks.remove(scopeId);
    }

    @LogicExtensionPoint(value="ClassForNameResolver")
    public <T> Class<T> classForNameResolver(String className) {
        throw new RuntimeException("Error with class resolving for class with name" + className);
    }

    public <T> T getInstance(String scopeId, String lepClassName) {
        Map tenantClasses = this.classCache.computeIfAbsent(scopeId, key -> new ConcurrentHashMap());
        Class lepClass = tenantClasses.computeIfAbsent(lepClassName, key -> this.self.classForNameResolver(lepClassName));
        return this.getInstance(scopeId, lepClass);
    }
}

