/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.lep.core;

import com.icthh.xm.commons.lep.impl.internal.MigrationFromCoreContextsHolderLepManagementServiceReference;
import com.icthh.xm.commons.tenant.Tenant;
import com.icthh.xm.commons.tenant.TenantContext;
import com.icthh.xm.commons.tenant.internal.DefaultTenantContextHolder;
import com.icthh.xm.lep.api.ContextsHolder;
import com.icthh.xm.lep.api.ScopedContext;
import com.icthh.xm.lep.core.DefaultScopedContext;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated(forRemoval=true)
public class CoreContextsHolder
implements ContextsHolder {
    private static volatile Map<String, ThreadLocal<ScopedContext>> contexts = new HashMap<String, ThreadLocal<ScopedContext>>();

    private static ThreadLocal<ScopedContext> getThreadLocalContext(String scope) {
        return contexts.get(scope);
    }

    @Override
    public ScopedContext getContext(String scope) {
        Objects.requireNonNull(scope, "scope can't be null");
        ThreadLocal<ScopedContext> threadLocalContext = CoreContextsHolder.getThreadLocalContext(scope);
        if (threadLocalContext == null) {
            throw new IllegalArgumentException("Unsupported context scope name: " + scope);
        }
        return threadLocalContext.get();
    }

    private ScopedContext beginContext(String scope) {
        ThreadLocal<ScopedContext> threadLocalContext = CoreContextsHolder.getThreadLocalContext(scope);
        threadLocalContext.set(new DefaultScopedContext(scope));
        return threadLocalContext.get();
    }

    private void endContext(String scope) {
        ThreadLocal<ScopedContext> threadLocalContext = CoreContextsHolder.getThreadLocalContext(scope);
        threadLocalContext.remove();
    }

    public ScopedContext beginThreadContext() {
        return this.beginContext("lep.system.thread");
    }

    public void endThreadContext() {
        this.endContext("lep.system.thread");
    }

    private static boolean isTenantContextPresent() {
        return new DefaultTenantContextHolder().getPrivilegedContext().getTenantKey().isPresent();
    }

    static {
        contexts.put("lep.system.thread", new MigrationBridgeThreadLocalContext());
        contexts.put("lep.system.execution", new ThreadLocal());
    }

    public static class MigrationBridgeThreadLocalContext
    extends ThreadLocal<ScopedContext> {
        private static final Logger log = LoggerFactory.getLogger(MigrationBridgeThreadLocalContext.class);

        @Override
        public void set(ScopedContext value) {
            super.set(value);
            if (CoreContextsHolder.isTenantContextPresent()) {
                log.warn("Begin thread context using deprecated method");
                MigrationFromCoreContextsHolderLepManagementServiceReference.getLepManagementServiceInstance().beginThreadContext();
            }
        }

        @Override
        public ScopedContext get() {
            ScopedContext scopedContext = (ScopedContext)super.get();
            if (scopedContext == null) {
                return scopedContext;
            }
            return new MigrationScopedContextBridge(scopedContext);
        }

        @Override
        public void remove() {
            super.remove();
            MigrationFromCoreContextsHolderLepManagementServiceReference.getLepManagementServiceInstance().endThreadContext();
        }
    }

    public static class MigrationScopedContextBridge
    implements ScopedContext {
        private static final Logger log = LoggerFactory.getLogger(MigrationScopedContextBridge.class);
        private final ScopedContext scopedContext;

        @Override
        public String getScope() {
            return "lep.system.thread";
        }

        @Override
        public Set<String> getNames() {
            return this.scopedContext.getNames();
        }

        @Override
        public boolean contains(String name) {
            return this.scopedContext.contains(name);
        }

        @Override
        public Object getValue(String key) {
            return this.scopedContext.getValue(key);
        }

        @Override
        public <T> T getValue(String name, Class<T> castToType) {
            return this.scopedContext.getValue(name, castToType);
        }

        @Override
        public void setValue(String key, Object value) {
            this.scopedContext.setValue(key, value);
            if (!CoreContextsHolder.isTenantContextPresent() && key.equals("tenantContext") && value instanceof TenantContext) {
                TenantContext tenantContext = (TenantContext)value;
                new DefaultTenantContextHolder().getPrivilegedContext().setTenant((Tenant)tenantContext.getTenant().get());
                log.warn("Begin thread context using deprecated method");
                MigrationFromCoreContextsHolderLepManagementServiceReference.getLepManagementServiceInstance().beginThreadContext();
            }
        }

        @Override
        public Map<String, Object> getValues() {
            return this.scopedContext.getValues();
        }

        public MigrationScopedContextBridge(ScopedContext scopedContext) {
            this.scopedContext = scopedContext;
        }
    }
}

