/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.lep;

import com.icthh.xm.commons.lep.BaseProceedingLep;
import com.icthh.xm.commons.lep.api.LepKey;
import com.icthh.xm.lep.api.LepMethod;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TargetProceedingLep
extends BaseProceedingLep {
    private static final Logger log = LoggerFactory.getLogger(TargetProceedingLep.class);
    private final LepKey lepKey;
    private final Object target;

    public TargetProceedingLep(Object target, LepMethod lepMethod, LepKey lepKey) {
        super(lepMethod);
        this.lepKey = lepKey;
        this.target = target;
    }

    @Override
    public Object proceed() throws Exception {
        return this.invoke(this.getMethodArgValues());
    }

    @Override
    public Object proceed(Object[] args) throws Exception {
        return this.invoke(args);
    }

    private Object invoke(Object ... args) throws Exception {
        Method method = this.getMethodSignature().getMethod();
        try {
            return method.invoke(this.target, args);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Error while processing target method: " + String.valueOf(method), e);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause == null) {
                throw new IllegalStateException("Invocation exception cause is null, while processing target method for LEP resource key: " + String.valueOf(this.lepKey));
            }
            if (cause instanceof Error) {
                throw (Error)Error.class.cast(cause);
            }
            if (cause instanceof Exception) {
                throw (Exception)Exception.class.cast(cause);
            }
            log.warn("Error execute LEP target method", (Throwable)e);
            throw new IllegalStateException("Error processing target method for LEP resource key: " + String.valueOf(this.lepKey) + ". " + cause.getMessage(), cause);
        }
    }

    @Override
    public Object getTarget() {
        return this.target;
    }
}

