/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.lep.impl.engine;

import com.icthh.xm.commons.lep.api.LepEngine;
import com.icthh.xm.commons.lep.api.LepExecutor;
import com.icthh.xm.commons.lep.api.LepExecutorResolver;
import com.icthh.xm.commons.lep.api.LepKey;
import com.icthh.xm.commons.lep.impl.engine.DefaultLepExecutor;
import com.icthh.xm.commons.lep.impl.engine.OriginalMethodLepExecutor;
import com.icthh.xm.commons.logging.util.MdcUtils;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TenantLepEngine
implements LepExecutorResolver {
    private static final Logger log = LoggerFactory.getLogger(TenantLepEngine.class);
    private final AtomicInteger countOfExecutions = new AtomicInteger();
    private final AtomicReference<TenantLepEnginesStates> state = new AtomicReference<TenantLepEnginesStates>(TenantLepEnginesStates.ACTIVE);
    private final String logId = MdcUtils.generateRid();
    private final String tenant;
    private final List<LepEngine> lepEngines;

    @Override
    public LepExecutor getLepExecutor(LepKey lepKey) {
        for (LepEngine lepEngine : this.lepEngines) {
            if (!lepEngine.isExists(lepKey)) continue;
            return new DefaultLepExecutor(lepEngine);
        }
        return new OriginalMethodLepExecutor();
    }

    @Override
    public void acquireUsage() {
        this.countOfExecutions.incrementAndGet();
    }

    @Override
    public void releaseUsage() {
        int executions = this.countOfExecutions.decrementAndGet();
        this.destroyTenantLepEngine(executions);
    }

    public boolean isActive() {
        return this.state.get() == TenantLepEnginesStates.ACTIVE;
    }

    public void destroy() {
        if (!this.state.compareAndSet(TenantLepEnginesStates.ACTIVE, TenantLepEnginesStates.DESTROYING)) {
            return;
        }
        log.debug("START | destroying lep engines for tenant {}", (Object)this.tenant);
    }

    private void destroyTenantLepEngine(int executions) {
        if (executions == 0 && this.state.get() == TenantLepEnginesStates.DESTROYING && this.state.compareAndSet(TenantLepEnginesStates.DESTROYING, TenantLepEnginesStates.DESTROYED)) {
            this.lepEngines.forEach(this::destroyEngine);
            log.debug("STOP | destroying lep engines for tenant {}", (Object)this.tenant);
        }
    }

    private void destroyEngine(LepEngine engine) {
        try {
            engine.destroy();
        }
        catch (Throwable e) {
            log.error("Error during destroy engine {}", (Object)this);
        }
    }

    public String toString() {
        String id = this.tenant + "_" + this.logId;
        return "TenantLepEngines(id=" + id + ", state=" + String.valueOf(this.state) + ", tenant=" + this.tenant + ", lepEngines.size=" + this.lepEngines.size() + ", countOfExecution=" + this.countOfExecutions.get() + ")";
    }

    public TenantLepEngine(String tenant, List<LepEngine> lepEngines) {
        this.tenant = tenant;
        this.lepEngines = lepEngines;
    }

    public String getTenant() {
        return this.tenant;
    }

    static enum TenantLepEnginesStates {
        ACTIVE,
        DESTROYING,
        DESTROYED;

    }
}

