/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.lep.impl.utils;

import com.icthh.xm.commons.lep.api.XmLepConfigFile;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.Scanners;
import org.springframework.core.io.InputStreamSource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;

public class ClassPathLepRepository {
    private final ResourceLoader resourceLoader;

    public Map<String, XmLepConfigFile> getLepFilesFromResources(String folderName) {
        Set<String> defaultLeps = this.getResourceFiles(folderName);
        HashMap<String, XmLepConfigFile> defauleLepsMap = new HashMap<String, XmLepConfigFile>();
        for (String fileName : defaultLeps) {
            Resource resource = this.resourceLoader.getResource("classpath:" + fileName);
            String relativePath = fileName.substring(folderName.length());
            defauleLepsMap.put(relativePath, new XmLepConfigFile(relativePath, (InputStreamSource)resource));
        }
        return defauleLepsMap;
    }

    private Set<String> getResourceFiles(String folderName) {
        Reflections reflections = new Reflections("lep", new Scanner[]{Scanners.Resources});
        return reflections.getResources(Pattern.compile(".*")).stream().filter(it -> it.startsWith(folderName)).collect(Collectors.toSet());
    }

    public ClassPathLepRepository(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }
}

