/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.logging.trace;

import io.micrometer.tracing.Span;
import io.micrometer.tracing.Tracer;
import io.micrometer.tracing.propagation.Propagator;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.stereotype.Component;

@Component
public class TraceWrapper {
    private static final Logger log = LoggerFactory.getLogger(TraceWrapper.class);
    private static final String WRAP_QUOTE_TOKEN = "\"";
    private static final String KAFKA_PROCESSING_TIMER = "kafka.processing.timer";
    private static final String SPAN_NAME_FROM_MESSAGE = "on-message";
    private final Tracer tracer;
    private final Propagator propagator;

    @Autowired
    public TraceWrapper(Tracer tracer, Propagator propagator) {
        this.tracer = tracer;
        this.propagator = propagator;
    }

    public void runWithSpan(ConsumerRecord<?, ?> record, Runnable codeToRun) {
        Span.Builder spanBuilder = this.propagator.extract(this.getRecordHeadersMap(record), Map::get);
        Span span = spanBuilder.name(SPAN_NAME_FROM_MESSAGE).start();
        this.runWithExistingSpan(span, codeToRun);
    }

    public void runWithSpan(Message<?> message, MessageChannel channel, Runnable codeToRun) {
        Span.Builder spanBuilder = this.propagator.extract(this.getMessageHeadersMap(message), Map::get);
        Span span = spanBuilder.name(KAFKA_PROCESSING_TIMER).start();
        this.runWithExistingSpan(span, codeToRun);
    }

    private void runWithExistingSpan(Span existingSpan, Runnable codeToRun) {
        log.trace("Opening span, {}", (Object)existingSpan.context().spanId());
        try (Tracer.SpanInScope ws = this.tracer.withSpan(existingSpan);){
            codeToRun.run();
        }
        catch (Exception e) {
            existingSpan.error((Throwable)e);
            throw e;
        }
        finally {
            log.trace("Closing span, {}", (Object)existingSpan.context().spanId());
            existingSpan.end();
        }
    }

    private Map<String, String> getRecordHeadersMap(ConsumerRecord<?, ?> record) {
        HashMap<String, String> headerMap = new HashMap<String, String>();
        record.headers().forEach(header -> headerMap.put(header.key(), TraceWrapper.unwrapQuotes(new String(header.value()))));
        return headerMap;
    }

    private Map<String, String> getMessageHeadersMap(Message<?> message) {
        HashMap<String, String> headerMap = new HashMap<String, String>();
        message.getHeaders().forEach((key, value) -> headerMap.put((String)key, TraceWrapper.unwrapQuotes(value.toString())));
        return headerMap;
    }

    public static String unwrapQuotes(String str) {
        if (StringUtils.isEmpty((CharSequence)str)) {
            return str;
        }
        int wrapLength = WRAP_QUOTE_TOKEN.length();
        if (str.startsWith(WRAP_QUOTE_TOKEN) && str.endsWith(WRAP_QUOTE_TOKEN)) {
            return str.substring(wrapLength, str.length() - wrapLength);
        }
        return str;
    }
}

