/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.metric;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.time.StopWatch;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.DescribeTopicsOptions;
import org.apache.kafka.clients.admin.DescribeTopicsResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.kafka.core.KafkaAdmin;

public class KafkaMetricsSet
implements MetricSet {
    private KafkaAdmin kafkaAdmin;
    private Integer connectionTimeoutTopic;
    private List<String> metricTopics;
    private final Logger log = LoggerFactory.getLogger(KafkaMetricsSet.class);

    public KafkaMetricsSet(KafkaAdmin kafkaAdmin, Integer connectionTimeoutTopic, List<String> metricTopics) {
        this.kafkaAdmin = kafkaAdmin;
        this.connectionTimeoutTopic = connectionTimeoutTopic;
        this.metricTopics = metricTopics;
    }

    public Map<String, Metric> getMetrics() {
        HashMap<String, Metric> metrics = new HashMap<String, Metric>();
        metrics.put("connection.success", (Metric)((Gauge)this::connectionToKafkaTopicsIsSuccess));
        return metrics;
    }

    public Boolean connectionToKafkaTopicsIsSuccess() {
        if (Objects.nonNull(this.metricTopics) && Objects.nonNull(this.connectionTimeoutTopic)) {
            StopWatch executionTime = StopWatch.createStarted();
            DescribeTopicsOptions describeTopicsOptions = new DescribeTopicsOptions().timeoutMs(this.connectionTimeoutTopic);
            Throwable throwable = null;
            try (AdminClient adminClient = AdminClient.create((Map)this.kafkaAdmin.getConfig());){
                DescribeTopicsResult describeTopicsResult = adminClient.describeTopics(this.metricTopics, describeTopicsOptions);
                Map topicDescriptionMap = (Map)describeTopicsResult.all().get();
                boolean monitoringResult = Objects.nonNull(topicDescriptionMap);
                this.log.info("Connection to Kafka topics is {}, time: {}", (Object)monitoringResult, (Object)executionTime.getTime());
                Boolean bl = monitoringResult;
                return bl;
            }
            catch (Exception e) {
                this.log.warn("Exception when try connect to kafka topics: {}, exception: {}, time: {}", new Object[]{this.metricTopics, e.getMessage(), executionTime.getTime()});
                Boolean bl = false;
                return bl;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        this.log.warn("metricTopics or connectionTimeoutTopic not found: {}, {}", this.metricTopics, (Object)this.connectionTimeoutTopic);
        return null;
    }
}

