/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.metric;

import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Slf4jReporter;
import com.codahale.metrics.health.HealthCheckRegistry;
import com.codahale.metrics.jmx.JmxReporter;
import com.codahale.metrics.jvm.BufferPoolMetricSet;
import com.codahale.metrics.jvm.FileDescriptorRatioGauge;
import com.codahale.metrics.jvm.GarbageCollectorMetricSet;
import com.codahale.metrics.jvm.JvmAttributeGaugeSet;
import com.codahale.metrics.jvm.MemoryUsageGaugeSet;
import com.codahale.metrics.jvm.ThreadStatesGaugeSet;
import com.icthh.xm.commons.metric.KafkaMetricsSet;
import com.icthh.xm.commons.metric.OperatingSystemGaugeSet;
import com.ryantenney.metrics.spring.config.annotation.EnableMetrics;
import com.ryantenney.metrics.spring.config.annotation.MetricsConfigurerAdapter;
import io.github.jhipster.config.JHipsterProperties;
import io.prometheus.client.Collector;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.dropwizard.DropwizardExports;
import java.lang.management.ManagementFactory;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.kafka.core.KafkaAdmin;

@Configuration
@EnableMetrics(proxyTargetClass=true)
public class MetricsConfiguration
extends MetricsConfigurerAdapter {
    private static final String PROP_METRIC_REG_JVM_MEMORY = "jvm.memory";
    private static final String PROP_METRIC_REG_JVM_GARBAGE = "jvm.garbage";
    private static final String PROP_METRIC_REG_JVM_THREADS = "jvm.threads";
    private static final String PROP_METRIC_REG_JVM_FILES = "jvm.files";
    private static final String PROP_METRIC_REG_JVM_BUFFERS = "jvm.buffers";
    private static final String PROP_METRIC_REG_JVM_ATTRIBUTE_SET = "jvm.attributes";
    private static final String PROP_METRIC_REG_OS = "os.attributes";
    private static final String PROP_METRIC_CONNECTION_TO_TOPIC = "kafka";
    private final Logger log = LoggerFactory.getLogger(MetricsConfiguration.class);
    private MetricRegistry metricRegistry = new MetricRegistry();
    private HealthCheckRegistry healthCheckRegistry = new HealthCheckRegistry();
    private final JHipsterProperties jhipsterProperties;
    private final KafkaAdmin kafkaAdmin;
    private final CollectorRegistry collectorRegistry;
    @Value(value="${spring.jmx.enabled:false}")
    private Boolean jmxEnabled;
    @Value(value="${application.kafkaMetric.enabled:false}")
    private Boolean kafkaMetricEnabled;
    @Value(value="${application.kafkaMetric.connectionTimeoutTopic:#{null}}")
    private Integer connectionTimeoutTopic;
    @Value(value="${application.kafkaMetric.metricTopics:#{null}}")
    private List<String> metricTopics;
    @Value(value="${management.metrics.export.prometheus.enabled}")
    private Boolean prometheusExportEnabled;

    public MetricsConfiguration(JHipsterProperties jhipsterProperties, KafkaAdmin kafkaAdmin, CollectorRegistry collectorRegistry) {
        this.jhipsterProperties = jhipsterProperties;
        this.kafkaAdmin = kafkaAdmin;
        this.collectorRegistry = collectorRegistry;
    }

    @Bean
    public MetricRegistry getMetricRegistry() {
        return this.metricRegistry;
    }

    @Bean
    public HealthCheckRegistry getHealthCheckRegistry() {
        return this.healthCheckRegistry;
    }

    @PostConstruct
    public void init() {
        this.log.debug("Registering JVM gauges");
        this.metricRegistry.register(PROP_METRIC_REG_JVM_MEMORY, (Metric)new MemoryUsageGaugeSet());
        this.metricRegistry.register(PROP_METRIC_REG_JVM_GARBAGE, (Metric)new GarbageCollectorMetricSet());
        this.metricRegistry.register(PROP_METRIC_REG_JVM_THREADS, (Metric)new ThreadStatesGaugeSet());
        this.metricRegistry.register(PROP_METRIC_REG_JVM_FILES, (Metric)new FileDescriptorRatioGauge());
        this.metricRegistry.register(PROP_METRIC_REG_JVM_BUFFERS, (Metric)new BufferPoolMetricSet(ManagementFactory.getPlatformMBeanServer()));
        this.metricRegistry.register(PROP_METRIC_REG_JVM_ATTRIBUTE_SET, (Metric)new JvmAttributeGaugeSet());
        this.metricRegistry.register(PROP_METRIC_REG_OS, (Metric)new OperatingSystemGaugeSet(ManagementFactory.getOperatingSystemMXBean()));
        if (this.jmxEnabled.booleanValue()) {
            this.log.debug("Initializing Metrics JMX reporting");
            JmxReporter jmxReporter = JmxReporter.forRegistry((MetricRegistry)this.metricRegistry).build();
            jmxReporter.start();
        }
        if (this.jhipsterProperties.getMetrics().getLogs().isEnabled()) {
            this.log.info("Initializing Metrics Log reporting");
            Marker metricsMarker = MarkerFactory.getMarker((String)"metrics");
            Slf4jReporter reporter = Slf4jReporter.forRegistry((MetricRegistry)this.metricRegistry).outputTo(LoggerFactory.getLogger((String)"metrics")).markWith(metricsMarker).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).build();
            reporter.start(this.jhipsterProperties.getMetrics().getLogs().getReportFrequency(), TimeUnit.SECONDS);
        }
        if (Boolean.TRUE.equals(this.kafkaMetricEnabled)) {
            this.metricRegistry.register(PROP_METRIC_CONNECTION_TO_TOPIC, (Metric)new KafkaMetricsSet(this.kafkaAdmin, this.connectionTimeoutTopic, this.metricTopics));
        }
        if (Boolean.TRUE.equals(this.prometheusExportEnabled)) {
            this.collectorRegistry.register((Collector)new DropwizardExports(this.metricRegistry));
        }
    }
}

