/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.metric;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricSet;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.management.Attribute;
import javax.management.InstanceNotFoundException;
import javax.management.ReflectionException;

public class OperatingSystemGaugeSet
implements MetricSet {
    private final OperatingSystemMXBean operatingSystemMXBean;

    public OperatingSystemGaugeSet(OperatingSystemMXBean mxBean) {
        this.operatingSystemMXBean = mxBean;
    }

    public Map<String, Metric> getMetrics() {
        HashMap<String, Metric> gauges = new HashMap<String, Metric>();
        gauges.put("committedVirtualMemorySize", (Metric)((Gauge)() -> this.invokeLong("CommittedVirtualMemorySize")));
        gauges.put("totalSwapSpaceSize", (Metric)((Gauge)() -> this.invokeLong("TotalSwapSpaceSize")));
        gauges.put("freeSwapSpaceSize", (Metric)((Gauge)() -> this.invokeLong("FreeSwapSpaceSize")));
        gauges.put("processCpuTime", (Metric)((Gauge)() -> this.invokeLong("ProcessCpuTime")));
        gauges.put("freePhysicalMemorySize", (Metric)((Gauge)() -> this.invokeLong("FreePhysicalMemorySize")));
        gauges.put("totalPhysicalMemorySize", (Metric)((Gauge)() -> this.invokeLong("TotalPhysicalMemorySize")));
        gauges.put("fileDescriptor.usage", (Metric)((Gauge)() -> this.invokeRatio("OpenFileDescriptorCount", "MaxFileDescriptorCount")));
        gauges.put("systemCpuLoad", (Metric)((Gauge)() -> this.invokeDouble("SystemCpuLoad")));
        gauges.put("processCpuLoad", (Metric)((Gauge)() -> this.invokeDouble("ProcessCpuLoad")));
        return gauges;
    }

    private Optional<Attribute> getOSAttribute(String attributeName) {
        List<Object> attributes;
        String[] attributesNames = new String[]{attributeName};
        try {
            attributes = ManagementFactory.getPlatformMBeanServer().getAttributes(this.operatingSystemMXBean.getObjectName(), attributesNames).asList();
        }
        catch (InstanceNotFoundException | ReflectionException ex) {
            attributes = Collections.emptyList();
        }
        return attributes.stream().filter(it -> attributeName.equals(it.getName())).findAny();
    }

    private long invokeLong(String attributeName) {
        return this.getOSAttribute(attributeName).map(value -> (long)((Long)value.getValue())).orElse(0L);
    }

    private double invokeDouble(String attributeName) {
        return this.getOSAttribute(attributeName).map(value -> (double)((Double)value.getValue())).orElse(0.0);
    }

    private double invokeRatio(String numeratorAttributeName, String denominatorAttributeName) {
        Optional<Long> numerator = this.getOSAttribute(numeratorAttributeName).map(it -> (long)((Long)it.getValue()));
        Optional<Long> denominator = this.getOSAttribute(denominatorAttributeName).map(it -> (long)((Long)it.getValue())).filter(it -> it != 0L);
        return numerator.map(numValue -> denominator.map(denValue -> 1.0 * (double)numValue.longValue() / (double)denValue.longValue()).orElse(Double.NaN)).orElse(Double.NaN);
    }
}

