/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.metric;

import com.icthh.xm.commons.metric.KafkaMetrics;
import com.icthh.xm.commons.metric.OperatingSystemMetrics;
import com.ryantenney.metrics.spring.config.annotation.EnableMetrics;
import com.ryantenney.metrics.spring.config.annotation.MetricsConfigurerAdapter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.binder.jvm.ClassLoaderMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmGcMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmMemoryMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmThreadMetrics;
import io.micrometer.core.instrument.binder.system.ProcessorMetrics;
import jakarta.annotation.PostConstruct;
import java.lang.management.ManagementFactory;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.kafka.core.KafkaAdmin;

@Configuration
@EnableMetrics(proxyTargetClass=true)
public class MetricsConfiguration
extends MetricsConfigurerAdapter {
    private final Logger log = LoggerFactory.getLogger(MetricsConfiguration.class);
    private final MeterRegistry meterRegistry;
    private final KafkaAdmin kafkaAdmin;
    @Value(value="${application.kafkaMetric.enabled:false}")
    private Boolean kafkaMetricEnabled;
    @Value(value="${application.kafkaMetric.connectionTimeoutTopic:#{null}}")
    private Integer connectionTimeoutTopic;
    @Value(value="${application.kafkaMetric.metricTopics:#{null}}")
    private List<String> metricTopics;

    public MetricsConfiguration(MeterRegistry meterRegistry, KafkaAdmin kafkaAdmin) {
        this.meterRegistry = meterRegistry;
        this.kafkaAdmin = kafkaAdmin;
    }

    @PostConstruct
    public void init() {
        this.log.debug("Registering JVM gauges");
        new ClassLoaderMetrics().bindTo(this.meterRegistry);
        new JvmMemoryMetrics().bindTo(this.meterRegistry);
        new JvmGcMetrics().bindTo(this.meterRegistry);
        new ProcessorMetrics().bindTo(this.meterRegistry);
        new JvmThreadMetrics().bindTo(this.meterRegistry);
        new OperatingSystemMetrics(ManagementFactory.getOperatingSystemMXBean()).bindTo(this.meterRegistry);
        if (Boolean.TRUE.equals(this.kafkaMetricEnabled)) {
            new KafkaMetrics(this.kafkaAdmin, this.connectionTimeoutTopic, this.metricTopics).bindTo(this.meterRegistry);
        }
    }
}

