/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.metric;

import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.binder.MeterBinder;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.commons.lang3.time.StopWatch;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.DescribeTopicsOptions;
import org.apache.kafka.clients.admin.DescribeTopicsResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.kafka.core.KafkaAdmin;

public class KafkaMetrics
implements MeterBinder {
    private static final String PROP_METRIC_KAFKA_CONNECTION_SUCCESS = "kafka.connection.success";
    private final KafkaAdmin kafkaAdmin;
    private final Integer connectionTimeoutTopic;
    private final List<String> metricTopics;
    private final Logger log = LoggerFactory.getLogger(KafkaMetrics.class);

    public KafkaMetrics(KafkaAdmin kafkaAdmin, Integer connectionTimeoutTopic, List<String> metricTopics) {
        this.kafkaAdmin = kafkaAdmin;
        this.connectionTimeoutTopic = connectionTimeoutTopic;
        this.metricTopics = metricTopics;
    }

    public void bindTo(MeterRegistry registry) {
        Gauge.builder((String)PROP_METRIC_KAFKA_CONNECTION_SUCCESS, () -> this.invokeLong(this::connectionToKafkaTopicsIsSuccess)).description("Whether connection to Kafka topics is successful").register(registry);
    }

    public Boolean connectionToKafkaTopicsIsSuccess() {
        if (Objects.nonNull(this.metricTopics) && Objects.nonNull(this.connectionTimeoutTopic)) {
            StopWatch executionTime = StopWatch.createStarted();
            DescribeTopicsOptions describeTopicsOptions = new DescribeTopicsOptions().timeoutMs(this.connectionTimeoutTopic);
            try (AdminClient adminClient = AdminClient.create((Map)this.kafkaAdmin.getConfigurationProperties());){
                DescribeTopicsResult describeTopicsResult = adminClient.describeTopics(this.metricTopics, describeTopicsOptions);
                Map topicDescriptionMap = (Map)describeTopicsResult.all().get();
                boolean monitoringResult = Objects.nonNull(topicDescriptionMap);
                this.log.info("Connection to Kafka topics is {}, time: {}", (Object)monitoringResult, (Object)executionTime.getTime());
                Boolean bl = monitoringResult;
                return bl;
            }
        }
        this.log.warn("metricTopics or connectionTimeoutTopic not found: {}, {}", this.metricTopics, (Object)this.connectionTimeoutTopic);
        return null;
    }

    private Number invokeLong(Supplier<Boolean> metricsSupplier) {
        return Boolean.TRUE.equals(metricsSupplier.get()) ? 1L : 0L;
    }
}

