/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.metric;

import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.binder.MeterBinder;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.management.Attribute;
import javax.management.InstanceNotFoundException;
import javax.management.ReflectionException;

public class OperatingSystemMetrics
implements MeterBinder {
    private final OperatingSystemMXBean operatingSystemMXBean;

    public OperatingSystemMetrics(OperatingSystemMXBean mxBean) {
        this.operatingSystemMXBean = mxBean;
    }

    public void bindTo(MeterRegistry registry) {
        Set<String> registeredMetrics = this.getRegisteredGauges(registry);
        if (!registeredMetrics.contains("committedVirtualMemorySize")) {
            Gauge.builder((String)"committedVirtualMemorySize", () -> this.invokeLong("CommittedVirtualMemorySize")).register(registry);
        }
        if (!registeredMetrics.contains("totalSwapSpaceSize")) {
            Gauge.builder((String)"totalSwapSpaceSize", () -> this.invokeLong("TotalSwapSpaceSize")).register(registry);
        }
        if (!registeredMetrics.contains("freeSwapSpaceSize")) {
            Gauge.builder((String)"freeSwapSpaceSize", () -> this.invokeLong("FreeSwapSpaceSize")).register(registry);
        }
        if (!registeredMetrics.contains("freeSwapSpaceSize")) {
            Gauge.builder((String)"freeSwapSpaceSize", () -> this.invokeLong("ProcessCpuTime")).register(registry);
        }
        if (!registeredMetrics.contains("freePhysicalMemorySize")) {
            Gauge.builder((String)"freePhysicalMemorySize", () -> this.invokeLong("FreePhysicalMemorySize")).register(registry);
        }
        if (!registeredMetrics.contains("totalPhysicalMemorySize")) {
            Gauge.builder((String)"totalPhysicalMemorySize", () -> this.invokeLong("TotalPhysicalMemorySize")).register(registry);
        }
        if (!registeredMetrics.contains("fileDescriptor.usage")) {
            Gauge.builder((String)"fileDescriptor.usage", () -> this.invokeRatio("OpenFileDescriptorCount", "MaxFileDescriptorCount")).register(registry);
        }
        if (!registeredMetrics.contains("systemCpuLoad")) {
            Gauge.builder((String)"systemCpuLoad", () -> this.invokeDouble("SystemCpuLoad")).register(registry);
        }
        if (!registeredMetrics.contains("processCpuLoad")) {
            Gauge.builder((String)"processCpuLoad", () -> this.invokeDouble("ProcessCpuLoad")).register(registry);
        }
    }

    private Set<String> getRegisteredGauges(MeterRegistry registry) {
        return registry.getMeters().stream().map(m -> m.getId().getName()).collect(Collectors.toSet());
    }

    private Optional<Attribute> getOSAttribute(String attributeName) {
        List<Object> attributes;
        String[] attributesNames = new String[]{attributeName};
        try {
            attributes = ManagementFactory.getPlatformMBeanServer().getAttributes(this.operatingSystemMXBean.getObjectName(), attributesNames).asList();
        }
        catch (InstanceNotFoundException | ReflectionException ex) {
            attributes = Collections.emptyList();
        }
        return attributes.stream().filter(it -> attributeName.equals(it.getName())).findAny();
    }

    private long invokeLong(String attributeName) {
        return this.getOSAttribute(attributeName).map(value -> (long)((Long)value.getValue())).orElse(0L);
    }

    private double invokeDouble(String attributeName) {
        return this.getOSAttribute(attributeName).map(value -> (double)((Double)value.getValue())).orElse(0.0);
    }

    private double invokeRatio(String numeratorAttributeName, String denominatorAttributeName) {
        Optional<Long> numerator = this.getOSAttribute(numeratorAttributeName).map(it -> (long)((Long)it.getValue()));
        Optional<Long> denominator = this.getOSAttribute(denominatorAttributeName).map(it -> (long)((Long)it.getValue())).filter(it -> it != 0L);
        return numerator.map(numValue -> denominator.map(denValue -> 1.0 * (double)numValue.longValue() / (double)denValue.longValue()).orElse(Double.NaN)).orElse(Double.NaN);
    }
}

