/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.migration.db.jsonb;

import com.icthh.xm.commons.migration.db.jsonb.Jsonb;
import com.vladmihalcea.hibernate.type.json.JsonBinaryType;
import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.Properties;
import org.hibernate.boot.SessionFactoryBuilder;
import org.hibernate.boot.internal.MetadataImpl;
import org.hibernate.boot.spi.MetadataImplementor;
import org.hibernate.boot.spi.SessionFactoryBuilderFactory;
import org.hibernate.boot.spi.SessionFactoryBuilderImplementor;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.PostgreSQL95Dialect;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.SimpleValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonbTypeRegistrator
implements SessionFactoryBuilderFactory {
    private static final Logger log = LoggerFactory.getLogger(JsonbTypeRegistrator.class);

    public SessionFactoryBuilder getSessionFactoryBuilder(MetadataImplementor metadata, SessionFactoryBuilderImplementor defaultBuilder) {
        MetadataImpl metadataImpl = (MetadataImpl)metadata;
        Dialect dialect = metadataImpl.getDatabase().getDialect();
        if (dialect instanceof PostgreSQL95Dialect) {
            log.info("Run on {} dialect. Metadata will be processed. And field marker as @Jsonb will be replaced to jsonb type.", (Object)dialect);
            metadataImpl.getEntityBindings().forEach(mapping -> this.updateEntityMapping(metadataImpl, mapping.getDeclaredPropertyIterator(), mapping.getMappedClass()));
        } else {
            log.info("Run on {} dialect. Metadata will not be processed", (Object)dialect);
        }
        return defaultBuilder;
    }

    private void updateEntityMapping(MetadataImpl metadata, Iterator<Property> propertyIterator, Class<?> persistentClass) {
        while (propertyIterator.hasNext()) {
            Property property = propertyIterator.next();
            if (property.isSynthetic()) continue;
            Class<?> fieldType = this.getField(persistentClass, property).getType();
            if (property.getValue() instanceof Component) {
                Component component = (Component)property.getValue();
                this.updateEntityMapping(metadata, component.getPropertyIterator(), fieldType);
                continue;
            }
            if (!(property.getValue() instanceof SimpleValue) || !this.isJsonb(persistentClass, property)) continue;
            this.updateMappingTypeToJsonb(metadata, property, fieldType.getCanonicalName());
        }
    }

    private boolean isJsonb(Class<?> persistentClass, Property property) {
        return this.getField(persistentClass, property).isAnnotationPresent(Jsonb.class);
    }

    private Field getField(Class<?> persistentClass, Property property) {
        return persistentClass.getDeclaredField(property.getName());
    }

    private void updateMappingTypeToJsonb(MetadataImpl metadata, Property jsonProperty, String fieldClassName) {
        log.info("Set type for {} to jsonb", (Object)jsonProperty.getName());
        SimpleValue simpleValue = new SimpleValue(metadata.getTypeConfiguration().getMetadataBuildingContext());
        simpleValue.setTypeName(JsonBinaryType.class.getCanonicalName());
        if (simpleValue.getTypeParameters() == null) {
            simpleValue.setTypeParameters(new Properties());
        }
        simpleValue.getTypeParameters().setProperty("org.hibernate.type.ParameterType.dynamic", Boolean.TRUE.toString());
        simpleValue.getTypeParameters().setProperty("org.hibernate.type.ParameterType.returnedClass", fieldClassName);
        simpleValue.setJpaAttributeConverterDescriptor(null);
        ((SimpleValue)jsonProperty.getValue()).copyTypeFrom(simpleValue);
    }
}

