/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.migration.db.tenant;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Component
public class SchemaChangeResolver {
    private static final Logger log = LoggerFactory.getLogger(SchemaChangeResolver.class);
    private static final String DEFAULT_COMMAND = "USE %s";
    private static final Map<String, String> DB_COMMANDS = new HashMap<String, String>();
    private String dbSchemaChangeCommand;

    public SchemaChangeResolver(Environment env) {
        this.initDbCommands(env);
        String db = env.getProperty("spring.jpa.database");
        this.dbSchemaChangeCommand = DB_COMMANDS.getOrDefault(db, DEFAULT_COMMAND);
        log.info("Database {} will use command '{}' for schema changing", (Object)db, (Object)this.dbSchemaChangeCommand);
    }

    public String getSchemaSwitchCommand() {
        return this.dbSchemaChangeCommand;
    }

    private void initDbCommands(Environment env) {
        String schemaSuffix = env.getProperty("application.db-schema-suffix", "");
        DB_COMMANDS.put("POSTGRESQL", "SET search_path TO %s" + schemaSuffix);
        DB_COMMANDS.put("ORACLE", "ALTER SESSION SET CURRENT_SCHEMA = %s" + schemaSuffix);
        DB_COMMANDS.put("H2", DEFAULT_COMMAND + schemaSuffix);
    }
}

