/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.migration.db.tenant;

import com.icthh.xm.commons.config.client.repository.TenantListRepository;
import com.icthh.xm.commons.migration.db.util.DatabaseUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Component
public class SchemaResolver {
    private static final Logger log = LoggerFactory.getLogger(SchemaResolver.class);
    private final Environment env;
    private final TenantListRepository tenantListRepository;

    public void createSchemas(DataSource dataSource) {
        Boolean schemaCreationEnabled = (Boolean)this.env.getProperty("spring.jpa.properties.db.schema.creation.enabled", Boolean.class, (Object)Boolean.TRUE);
        if (!schemaCreationEnabled.booleanValue()) {
            log.info("Schema creation for {} jpa provider is disabled", (Object)this.env.getProperty("spring.jpa.database"));
            return;
        }
        List<String> schemas = this.getSchemas();
        log.info("Create [{}] schemas for all tenants before liquibase migration", (Object)schemas.size());
        for (String schema : schemas) {
            try {
                DatabaseUtil.createSchema(dataSource, schema);
            }
            catch (Exception e) {
                log.error("Failed to create schema '{}', error: {}", new Object[]{schema, e.getMessage(), e});
            }
        }
    }

    public List<String> getSchemas() {
        String suffix = this.env.getProperty("application.db-schema-suffix");
        ArrayList<String> schemas = new ArrayList<String>(this.tenantListRepository.getTenants());
        if (StringUtils.isNotBlank((CharSequence)suffix)) {
            return schemas.stream().map(schema -> schema.concat(suffix)).collect(Collectors.toList());
        }
        return schemas;
    }

    public SchemaResolver(Environment env, TenantListRepository tenantListRepository) {
        this.env = env;
        this.tenantListRepository = tenantListRepository;
    }
}

