/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.migration.db.util;

import com.icthh.xm.commons.tenant.TenantContextUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DatabaseUtil {
    private static final Logger log = LoggerFactory.getLogger(DatabaseUtil.class);

    public static void createSchema(DataSource dataSource, String name) throws SQLException {
        TenantContextUtils.assertTenantKeyValid((String)name);
        DatabaseUtil.executeUpdateWithAutoCommit(dataSource, String.format("CREATE SCHEMA IF NOT EXISTS %s", name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeUpdateWithAutoCommit(DataSource dataSource, String sql) throws SQLException {
        Connection connection = null;
        boolean autocommitBefore = false;
        Statement statement = null;
        try {
            connection = dataSource.getConnection();
            autocommitBefore = connection.getAutoCommit();
            statement = connection.createStatement();
            connection.setAutoCommit(true);
            log.info("execute sql: [{}], autocommit = {}", (Object)sql, (Object)connection.getAutoCommit());
            int res = statement.executeUpdate(sql);
            log.debug("result = {}", (Object)res);
        }
        finally {
            if (statement != null && !statement.isClosed()) {
                log.debug("close statement!");
                statement.close();
            }
            if (connection != null) {
                connection.setAutoCommit(autocommitBefore);
                if (!connection.isClosed()) {
                    log.debug("close connection! autocommit = {}", (Object)connection.getAutoCommit());
                    connection.close();
                }
            }
        }
    }

    private DatabaseUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

