/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.permission.repository;

import com.google.common.annotations.VisibleForTesting;
import com.icthh.xm.commons.permission.service.PermissionCheckService;
import com.icthh.xm.commons.permission.service.translator.SpelToJpqlTranslator;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityGraph;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Subgraph;
import javax.persistence.TypedQuery;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.repository.support.PageableExecutionUtils;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;

@Repository
public class PermittedRepository {
    private static final Logger log = LoggerFactory.getLogger(PermittedRepository.class);
    public static final String SELECT_ALL_SQL = "select distinct returnObject from %s returnObject";
    public static final String COUNT_ALL_SQL = "select distinct count(returnObject) from %s returnObject";
    public static final String WHERE_SQL = " where ";
    public static final String AND_SQL = " and ";
    public static final String ORDER_BY_SQL = " order by ";
    private static final String GRAPH_DELIMETER = ".";
    private final SpelToJpqlTranslator spelToJpqlTranslator = new SpelToJpqlTranslator();
    private final PermissionCheckService permissionCheckService;
    @PersistenceContext
    @VisibleForTesting
    private EntityManager em;

    public <T> List<T> findAll(Class<T> entityClass, String privilegeKey) {
        return this.findAll(null, entityClass, privilegeKey).getContent();
    }

    public <T> Page<T> findAll(Pageable pageable, Class<T> entityClass, String privilegeKey) {
        Object selectSql = String.format(SELECT_ALL_SQL, entityClass.getSimpleName());
        Object countSql = String.format(COUNT_ALL_SQL, entityClass.getSimpleName());
        String orChainedPermittedCondition = this.createPermissionCondition(privilegeKey);
        if (StringUtils.isNotEmpty((CharSequence)orChainedPermittedCondition)) {
            selectSql = (String)selectSql + WHERE_SQL + orChainedPermittedCondition;
            countSql = (String)countSql + WHERE_SQL + orChainedPermittedCondition;
        }
        log.debug("Executing SQL '{}'", selectSql);
        return this.execute(this.createCountQuery((String)countSql), pageable, this.createSelectQuery((String)selectSql, pageable, entityClass));
    }

    public <T> List<T> findByCondition(String whereCondition, Map<String, Object> conditionParams, Class<T> entityClass, String privilegeKey) {
        return this.findByCondition(whereCondition, conditionParams, null, entityClass, privilegeKey).getContent();
    }

    public <T> Page<T> findByCondition(String whereCondition, Map<String, Object> conditionParams, Pageable pageable, Class<T> entityClass, String privilegeKey) {
        return this.findByCondition(whereCondition, conditionParams, null, pageable, entityClass, privilegeKey);
    }

    public <T> Page<T> findByCondition(String whereCondition, Map<String, Object> conditionParams, Collection<String> embed, Pageable pageable, Class<T> entityClass, String privilegeKey) {
        Object selectSql = String.format(SELECT_ALL_SQL, entityClass.getSimpleName());
        Object countSql = String.format(COUNT_ALL_SQL, entityClass.getSimpleName());
        selectSql = (String)selectSql + WHERE_SQL + whereCondition;
        countSql = (String)countSql + WHERE_SQL + whereCondition;
        String orChainedPermittedCondition = this.createPermissionCondition(privilegeKey);
        if (StringUtils.isNotEmpty((CharSequence)orChainedPermittedCondition)) {
            selectSql = (String)selectSql + AND_SQL + orChainedPermittedCondition;
            countSql = (String)countSql + AND_SQL + orChainedPermittedCondition;
        }
        TypedQuery selectQuery = this.createSelectQuery((String)selectSql, pageable, entityClass);
        if (!CollectionUtils.isEmpty(embed)) {
            selectQuery.setHint("javax.persistence.loadgraph", this.createEnitityGraph(embed, entityClass));
        }
        TypedQuery<Long> countQuery = this.createCountQuery((String)countSql);
        conditionParams.forEach((paramName, paramValue) -> {
            selectQuery.setParameter(paramName, paramValue);
            countQuery.setParameter(paramName, paramValue);
        });
        log.debug("Executing SQL '{}' with params '{}'", selectQuery, conditionParams);
        return this.execute(countQuery, pageable, selectQuery);
    }

    protected <T> TypedQuery<T> createSelectQuery(String selectSql, Pageable pageable, Class<T> entityClass) {
        Sort sort = pageable == null ? null : pageable.getSort();
        return this.em.createQuery(PermittedRepository.applyOrder(selectSql, sort), entityClass);
    }

    protected TypedQuery<Long> createCountQuery(String countSql) {
        return this.em.createQuery(countSql, Long.class);
    }

    protected <T> Page<T> execute(TypedQuery<Long> countSql, Pageable pageable, TypedQuery<T> query) {
        return pageable == null ? new Page<T>(query.getResultList()) : this.readPage(countSql, query, pageable);
    }

    protected String createPermissionCondition(String privilegeKey) {
        return this.permissionCheckService.createCondition(SecurityContextHolder.getContext().getAuthentication(), privilegeKey, this.spelToJpqlTranslator);
    }

    private static String applyOrder(String sql, Sort sort) {
        StringBuilder builder = new StringBuilder(sql);
        if (sort != null && !sort.equals((Object)Sort.unsorted())) {
            builder.append(ORDER_BY_SQL);
            String sep = "";
            for (Sort.Order order : sort) {
                builder.append(sep).append(order.getProperty()).append(" ").append(order.getDirection());
                sep = ", ";
            }
        }
        return builder.toString();
    }

    private <T> Page<T> readPage(TypedQuery<Long> countQuery, TypedQuery<T> query, Pageable pageable) {
        query.setFirstResult(Math.toIntExact(pageable.getOffset()));
        query.setMaxResults(pageable.getPageSize());
        return PageableExecutionUtils.getPage((List)query.getResultList(), (Pageable)pageable, () -> PermittedRepository.executeCountQuery(countQuery));
    }

    private static Long executeCountQuery(TypedQuery<Long> query) {
        List totals = query.getResultList();
        Long total = 0L;
        for (Long element : totals) {
            total = total + (element == null ? 0L : element);
        }
        return total;
    }

    private <T> EntityGraph<T> createEnitityGraph(Collection<String> embed, Class<T> domainClass) {
        EntityGraph graph = this.em.createEntityGraph(domainClass);
        if (!CollectionUtils.isEmpty(embed)) {
            embed.forEach(f -> PermittedRepository.addAttributeNodes(f, graph));
        }
        return graph;
    }

    private static void addAttributeNodes(String fieldName, EntityGraph<?> graph) {
        int pos = fieldName.indexOf(GRAPH_DELIMETER);
        if (pos < 0) {
            graph.addAttributeNodes(new String[]{fieldName});
            return;
        }
        String subgraphName = fieldName.substring(0, pos);
        Subgraph subGraph = graph.addSubgraph(subgraphName);
        String nextFieldName = fieldName.substring(pos + 1);
        pos = nextFieldName.indexOf(GRAPH_DELIMETER);
        while (pos > 0) {
            subgraphName = nextFieldName.substring(0, pos);
            subGraph = subGraph.addSubgraph(subgraphName);
            nextFieldName = nextFieldName.substring(pos + 1);
            pos = nextFieldName.indexOf(GRAPH_DELIMETER);
        }
        subGraph.addAttributeNodes(new String[]{nextFieldName});
    }

    public PermittedRepository(PermissionCheckService permissionCheckService) {
        this.permissionCheckService = permissionCheckService;
    }

    void setEm(EntityManager em) {
        this.em = em;
    }
}

