/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.permission.service;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import io.github.jhipster.service.filter.Filter;
import io.github.jhipster.service.filter.RangeFilter;
import io.github.jhipster.service.filter.StringFilter;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.springframework.cglib.beans.BeanMap;

public class FilterConverter {
    public static <T> QueryPart toJpql(T criteria) {
        return FilterConverter.toJpql((Map<String, Filter>)BeanMap.create(criteria));
    }

    private static QueryPart toJpql(Map<String, Filter> filterMap) {
        return filterMap.entrySet().stream().filter(s -> s.getValue() != null).flatMap(FilterConverter::resolveExpression).collect(QueryPart::new, (x$0, x$1) -> QueryPart.accumulateExpression(x$0, x$1), (x$0, x$1) -> QueryPart.combineQueryParts(x$0, x$1));
    }

    private static Stream<Expression> resolveExpression(Map.Entry<String, Filter> entry) {
        Stream.Builder<Expression> expressions = Stream.builder();
        Filter filter = entry.getValue();
        String fieldName = FilterConverter.preProcessForeignKeyField(entry.getKey());
        if (filter.getEquals() != null) {
            expressions.add(new Expression(fieldName, Operation.EQUALS, filter.getEquals()));
        }
        if (filter.getSpecified() != null) {
            Boolean specified = filter.getSpecified();
            expressions.add(new Expression(fieldName, specified != false ? Operation.SPECIFIED : Operation.NOT_SPECIFIED, specified));
        }
        if (filter.getIn() != null) {
            expressions.add(new Expression(fieldName, Operation.IN, filter.getIn()));
        }
        if (filter instanceof StringFilter && ((StringFilter)filter).getContains() != null) {
            expressions.add(new Expression(fieldName, Operation.CONTAINS, ((StringFilter)filter).getContains()));
        }
        if (filter instanceof RangeFilter) {
            RangeFilter rangeFilter = (RangeFilter)filter;
            if (rangeFilter.getGreaterThan() != null) {
                expressions.add(new Expression(fieldName, Operation.GREATER_THAN, rangeFilter.getGreaterThan()));
            }
            if (rangeFilter.getGreaterThanOrEqual() != null) {
                expressions.add(new Expression(fieldName, Operation.GREATER_OR_EQ_THAN, rangeFilter.getGreaterThanOrEqual()));
            }
            if (rangeFilter.getLessThan() != null) {
                expressions.add(new Expression(fieldName, Operation.LESS_THAN, rangeFilter.getLessThan()));
            }
            if (rangeFilter.getLessThanOrEqual() != null) {
                expressions.add(new Expression(fieldName, Operation.LESS_OR_EQ_THAN, rangeFilter.getLessThanOrEqual()));
            }
        }
        return expressions.build();
    }

    private static String preProcessForeignKeyField(String fieldName) {
        if (fieldName.endsWith("Id")) {
            return fieldName.replaceFirst("Id$", "_id");
        }
        return fieldName;
    }

    public static enum Operation {
        EQUALS(" = ", true),
        SPECIFIED(" is not null ", false),
        NOT_SPECIFIED(" is null ", false),
        IN(" in ", true),
        CONTAINS(" like ", true),
        GREATER_THAN(" > ", true),
        LESS_THAN(" < ", true),
        GREATER_OR_EQ_THAN(" >= ", true),
        LESS_OR_EQ_THAN(" <= ", true);

        private final String jpqlOp;
        private final boolean paramRequired;

        private Operation(String jpqlOp, boolean paramRequired) {
            this.jpqlOp = jpqlOp;
            this.paramRequired = paramRequired;
        }

        public String getJpqlOp() {
            return this.jpqlOp;
        }

        public boolean isParamRequired() {
            return this.paramRequired;
        }
    }

    public static class Expression {
        public static final String JPQL_ALIAS_PREFIX = ":";
        String fieldName;
        Operation operation;
        Object value;

        boolean isOperationParamRequired() {
            return this.operation.isParamRequired();
        }

        String toJpql(String alias) {
            String jpql = this.fieldName + this.operation.getJpqlOp();
            if (this.operation.isParamRequired()) {
                jpql = jpql + JPQL_ALIAS_PREFIX + alias;
            }
            return jpql;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public Operation getOperation() {
            return this.operation;
        }

        public Object getValue() {
            return this.value;
        }

        public Expression(String fieldName, Operation operation, Object value) {
            this.fieldName = fieldName;
            this.operation = operation;
            this.value = value;
        }

        public String toString() {
            return "FilterConverter.Expression(fieldName=" + this.getFieldName() + ", operation=" + this.getOperation() + ", value=" + this.getValue() + ")";
        }
    }

    public static class QueryPart {
        public static final String JPQL_AND = " and ";
        StringBuilder query = new StringBuilder();
        Map<String, Object> params = new HashMap<String, Object>();
        Multiset<String> aliases = HashMultiset.create();

        public boolean isEmpty() {
            return this.query.length() == 0;
        }

        String getNextAliasName(String fieldName) {
            int cnt = this.aliases.count((Object)fieldName);
            this.aliases.add((Object)fieldName);
            return cnt == 0 ? fieldName : fieldName + cnt;
        }

        private static void accumulateExpression(QueryPart qp, Expression expression) {
            String paramAlias = qp.getNextAliasName(expression.getFieldName());
            if (qp.isEmpty()) {
                qp.getQuery().append(expression.toJpql(paramAlias));
            } else {
                qp.getQuery().append(JPQL_AND).append(expression.toJpql(paramAlias));
            }
            if (expression.isOperationParamRequired()) {
                qp.getParams().put(paramAlias, expression.getValue());
            }
        }

        private static QueryPart combineQueryParts(QueryPart qp1, QueryPart qp2) {
            qp1.getQuery().append(JPQL_AND).append((CharSequence)qp2.getQuery());
            qp1.getParams().putAll(qp2.getParams());
            return qp1;
        }

        public StringBuilder getQuery() {
            return this.query;
        }

        public Map<String, Object> getParams() {
            return this.params;
        }

        public Multiset<String> getAliases() {
            return this.aliases;
        }

        public String toString() {
            return "FilterConverter.QueryPart(query=" + this.getQuery() + ", params=" + this.getParams() + ", aliases=" + this.getAliases() + ")";
        }
    }
}

