/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.permission.repository;

import com.icthh.xm.commons.permission.repository.PermittedRepository;
import com.icthh.xm.commons.permission.service.FilterConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Repository;

@Repository
public class CriteriaPermittedRepository {
    private static final Logger log = LoggerFactory.getLogger(CriteriaPermittedRepository.class);
    private final PermittedRepository permittedRepository;

    public <T> Page<T> findWithPermission(Class<T> type, Object criteria, Pageable page, String privilegeKey) {
        Page<T> result;
        FilterConverter.QueryPart queryPart = FilterConverter.toJpql(criteria);
        if (queryPart.isEmpty()) {
            result = this.permittedRepository.findAll(page, type, privilegeKey);
        } else {
            log.debug("find with condition: {}", (Object)queryPart);
            result = this.permittedRepository.findByCondition(queryPart.getQuery().toString(), queryPart.getParams(), page, type, privilegeKey);
        }
        return result;
    }

    public <T> long countByCondition(Class<T> type, Object criteria, String privilegeKey) {
        long result;
        FilterConverter.QueryPart queryPart = FilterConverter.toJpql(criteria);
        if (queryPart.isEmpty()) {
            result = this.permittedRepository.count(type, privilegeKey);
        } else {
            log.debug("find with condition: {}", (Object)queryPart);
            result = this.permittedRepository.countByCondition(queryPart.getQuery().toString(), queryPart.getParams(), type, privilegeKey);
        }
        return result;
    }

    public CriteriaPermittedRepository(PermittedRepository permittedRepository) {
        this.permittedRepository = permittedRepository;
    }
}

