/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.permission.service;

import com.icthh.xm.commons.config.client.api.RefreshableConfiguration;
import com.icthh.xm.commons.logging.aop.IgnoreLogginAspect;
import com.icthh.xm.commons.permission.config.PermissionProperties;
import com.icthh.xm.commons.permission.domain.Role;
import com.icthh.xm.commons.permission.domain.mapper.RoleMapper;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.AntPathMatcher;

@Service
@IgnoreLogginAspect
public class RoleService
implements RefreshableConfiguration {
    private static final Logger log = LoggerFactory.getLogger(RoleService.class);
    private static final String TENANT_NAME = "tenantName";
    private ConcurrentHashMap<String, Map<String, Role>> roles = new ConcurrentHashMap();
    private final AntPathMatcher matcher = new AntPathMatcher();
    private final PermissionProperties permissionProperties;

    public Map<String, Role> getRoles(String tenant) {
        if (!this.roles.containsKey(tenant)) {
            return new HashMap<String, Role>();
        }
        return this.roles.get(tenant);
    }

    public void onRefresh(String key, String config) {
        try {
            String tenant = (String)this.matcher.extractUriTemplateVariables(this.permissionProperties.getRolesSpecPath(), key).get(TENANT_NAME);
            if (StringUtils.isBlank((CharSequence)config)) {
                this.roles.remove(tenant);
                log.info("Role specification for tenant {} was removed", (Object)tenant);
            } else {
                this.roles.put(tenant, RoleMapper.ymlToRoles(config));
                log.info("Role specification for tenant {} was updated", (Object)tenant);
            }
        }
        catch (Exception e) {
            log.error("Error read role specification from path " + key, (Throwable)e);
        }
    }

    public boolean isListeningConfiguration(String key) {
        return this.matcher.match(this.permissionProperties.getRolesSpecPath(), key);
    }

    public void onInit(String key, String config) {
        this.onRefresh(key, config);
    }

    public RoleService(PermissionProperties permissionProperties) {
        this.permissionProperties = permissionProperties;
    }
}

