/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.permission.utils;

import com.icthh.xm.commons.security.XmAuthenticationContext;
import com.icthh.xm.commons.security.XmAuthenticationContextHolder;
import com.icthh.xm.commons.security.internal.XmAuthenticationDetails;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.web.authentication.WebAuthenticationDetails;

public final class SecurityUtils {
    public static final String AUTH_ADDITIONAL_DETAILS = "additionalDetails";

    public static boolean getAdditionalDetailsValueBoolean(Authentication authentication, String fieldName) {
        return SecurityUtils.getDetailsValue(authentication, AUTH_ADDITIONAL_DETAILS, HashMap.class).map(additionalDetails -> additionalDetails.get(fieldName)).filter(Boolean.class::isInstance).map(Boolean.class::cast).orElse(false);
    }

    private static <T> Optional<T> getDetailsValue(Authentication authentication, String key, Class<T> valueType) {
        return Optional.ofNullable(authentication).map(Authentication::getDetails).map(SecurityUtils::toDetailsMap).map(allDetail -> SecurityUtils.toDetailsValue(allDetail, key, valueType));
    }

    private static <T> T toDetailsValue(Map<?, ?> allDetail, String key, Class<T> valueType) {
        Object value = allDetail.get(key);
        if (Objects.isNull(value)) {
            return null;
        }
        if (!valueType.isAssignableFrom(value.getClass())) {
            throw new IllegalArgumentException(String.format("Can't convert detail with type %s to %s", value.getClass().getName(), valueType.getName()));
        }
        return valueType.cast(value);
    }

    private static Map<?, ?> toDetailsMap(Object details) {
        if (details instanceof XmAuthenticationDetails) {
            return Optional.of(details).map(XmAuthenticationDetails.class::cast).map(XmAuthenticationDetails::getDecodedDetails).orElseGet(Collections::emptyMap);
        }
        if (details instanceof WebAuthenticationDetails) {
            return Collections.emptyMap();
        }
        throw new IllegalStateException("Unsupported auth details type " + String.valueOf(details.getClass()));
    }

    public static String getUserKeyOrNull(XmAuthenticationContextHolder contextHolder) {
        return Optional.ofNullable(contextHolder).map(XmAuthenticationContextHolder::getContext).flatMap(XmAuthenticationContext::getUserKey).orElse(null);
    }

    public static String getRoleKeyOrNull(Authentication authentication) {
        return Optional.ofNullable(authentication).map(Authentication::getAuthorities).map(Collection::stream).flatMap(Stream::findFirst).map(GrantedAuthority::getAuthority).orElse(null);
    }

    private SecurityUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

