/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.permission.domain.mapper;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.icthh.xm.commons.permission.domain.Permission;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PermissionMapper {
    private static final Logger log = LoggerFactory.getLogger(PermissionMapper.class);
    private static final ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());

    public static String permissionsToYml(Collection<Permission> permissions) {
        try {
            TreeMap map = new TreeMap();
            permissions.forEach(permission -> {
                map.putIfAbsent(permission.getMsName(), new TreeMap());
                ((Map)map.get(permission.getMsName())).putIfAbsent(permission.getRoleKey(), new TreeSet());
                ((Set)((Map)map.get(permission.getMsName())).get(permission.getRoleKey())).add(permission);
            });
            return mapper.writeValueAsString(map);
        }
        catch (Exception e) {
            log.error("Failed to create permissions YML file from collection, error: {}", (Object)e.getMessage(), (Object)e);
            return null;
        }
    }

    @Deprecated(forRemoval=true)
    public static Map<String, Permission> ymlToPermissions(String yml) {
        return PermissionMapper.ymlToPermissions(yml, null);
    }

    @Deprecated(forRemoval=true)
    public static Map<String, Permission> ymlToPermissions(String yml, String msName) {
        TreeMap result = new TreeMap();
        try {
            TreeMap map = (TreeMap)mapper.readValue(yml, (TypeReference)new TypeReference<TreeMap<String, TreeMap<String, TreeSet<Permission>>>>(){});
            map.entrySet().stream().filter(entry -> StringUtils.isBlank((CharSequence)msName) || StringUtils.startsWithIgnoreCase((CharSequence)((CharSequence)entry.getKey()), (CharSequence)msName)).filter(entry -> entry.getValue() != null).forEach(entry -> ((TreeMap)entry.getValue()).forEach((roleKey, permissions) -> permissions.forEach(permission -> {
                permission.setMsName((String)entry.getKey());
                permission.setRoleKey((String)roleKey);
                result.put(roleKey + ":" + permission.getPrivilegeKey(), permission);
            })));
        }
        catch (Exception e) {
            log.error("Failed to create permissions collection from YML file, error: {}", (Object)e.getMessage(), (Object)e);
        }
        return Collections.unmodifiableMap(result);
    }

    private PermissionMapper() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

