/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.permission.inspector.scanner;

import com.icthh.xm.commons.permission.annotation.FindWithPermission;
import com.icthh.xm.commons.permission.annotation.PrivilegeDescription;
import com.icthh.xm.commons.permission.domain.Privilege;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.reflections.Reflections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.security.access.prepost.PostFilter;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@Component
public class PrivilegeScanner {
    private static final Logger log = LoggerFactory.getLogger(PrivilegeScanner.class);
    private final Reflections reflections;
    @Value(value="${spring.application.name}")
    private String appName;

    public Set<Privilege> scan() {
        StopWatch stopWatch = StopWatch.createStarted();
        HashSet<Privilege> privileges = new HashSet<Privilege>();
        HashSet<Method> securedMethods = new HashSet<Method>();
        this.loadMethods(securedMethods, PreAuthorize.class);
        this.loadMethods(securedMethods, PostAuthorize.class);
        this.loadMethods(securedMethods, FindWithPermission.class);
        this.loadMethods(securedMethods, PostFilter.class);
        for (Method method : securedMethods) {
            PreAuthorize preAuthorize = method.getAnnotation(PreAuthorize.class);
            PostAuthorize postAuthorize = method.getAnnotation(PostAuthorize.class);
            FindWithPermission findWithPermission = method.getAnnotation(FindWithPermission.class);
            PostFilter postFilter = method.getAnnotation(PostFilter.class);
            Privilege privilege = new Privilege();
            if (Objects.nonNull(preAuthorize)) {
                privilege = this.parse(preAuthorize.value());
            }
            if (Objects.nonNull(postAuthorize)) {
                privilege = this.parse(postAuthorize.value());
            }
            if (Objects.nonNull(findWithPermission)) {
                privilege = this.parse(findWithPermission.value());
                privilege.getResources().add("returnObject");
            }
            if (Objects.nonNull(postFilter)) {
                privilege = this.parse(postFilter.value());
                privilege.getResources().add("returnObject");
            }
            if (!Objects.nonNull(privilege.getKey())) continue;
            this.updateCustomPrivilege(method, privilege);
            privileges.add(privilege);
        }
        log.info("Found {} privileges in {} ms", (Object)privileges.size(), (Object)stopWatch.getTime());
        return privileges;
    }

    private void updateCustomPrivilege(Method method, Privilege privilege) {
        if (method.isAnnotationPresent(PrivilegeDescription.class)) {
            String customDescription = method.getAnnotation(PrivilegeDescription.class).value();
            if (StringUtils.isNotEmpty((CharSequence)customDescription)) {
                privilege.setCustomDescription(customDescription);
            }
        } else {
            log.warn("Privilege [{}] does not have description. Add annotation @PrivilegeDescription to: {}", (Object)privilege.getKey(), (Object)method);
        }
    }

    private void loadMethods(Set<Method> securedMethods, Class<? extends Annotation> annotation) {
        securedMethods.addAll(this.reflections.getMethodsAnnotatedWith(annotation));
    }

    private Privilege parse(String expression) {
        Privilege privilege = new Privilege();
        privilege.setMsName(this.appName);
        String[] inputParams = StringUtils.split((String)expression, (String)",");
        for (int i = 0; i < inputParams.length; ++i) {
            if (i == inputParams.length - 1) {
                if (StringUtils.contains((CharSequence)inputParams[i], (CharSequence)"'")) {
                    privilege.setKey(StringUtils.substringBetween((String)inputParams[i], (String)"'").replace("@msName", this.appName.toUpperCase()));
                    continue;
                }
                privilege.setKey(inputParams[i].replace("@msName", this.appName.toUpperCase()));
                continue;
            }
            String resource = StringUtils.substringBetween((String)inputParams[i], (String)"'");
            if (!StringUtils.isNotEmpty((CharSequence)resource)) continue;
            privilege.getResources().add(resource);
        }
        return privilege;
    }

    public PrivilegeScanner(Reflections reflections) {
        this.reflections = reflections;
    }
}

