/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.permission.service;

import com.icthh.xm.commons.security.internal.XmAuthentication;
import com.icthh.xm.commons.security.internal.XmAuthenticationDetails;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import org.springframework.security.core.Authentication;

public class AuthenticationSecurityExpressionMethods {
    private final Authentication authentication;
    private Set<String> missingScopes = new LinkedHashSet<String>();

    public boolean clientHasRole(String role) {
        return this.clientHasAnyRole(role);
    }

    public boolean clientHasAnyRole(String ... roles) {
        Authentication authentication = this.authentication;
        if (authentication instanceof XmAuthentication) {
            XmAuthentication xmAuthentication = (XmAuthentication)authentication;
            Set authorities = Optional.ofNullable(xmAuthentication.getDetails()).map(XmAuthenticationDetails::getAuthorities).orElse(Set.of());
            return Arrays.stream(roles).anyMatch(authorities::contains);
        }
        return false;
    }

    public boolean hasScope(String scope) {
        return this.hasAnyScope(scope);
    }

    public boolean hasAnyScope(String ... scopes) {
        boolean result = AuthenticationSecurityExpressionMethods.hasAnyScope(this.authentication, scopes);
        if (!result) {
            this.missingScopes.addAll(Arrays.asList(scopes));
        }
        return result;
    }

    public boolean hasScopeMatching(String scopeRegex) {
        return this.hasAnyScopeMatching(scopeRegex);
    }

    public boolean hasAnyScopeMatching(String ... scopesRegex) {
        boolean result = AuthenticationSecurityExpressionMethods.hasAnyScopeMatching(this.authentication, scopesRegex);
        if (!result) {
            this.missingScopes.addAll(Arrays.asList(scopesRegex));
        }
        return result;
    }

    private static boolean hasAnyScope(Authentication authentication, String[] scopes) {
        if (authentication instanceof XmAuthentication) {
            XmAuthentication xmAuthentication = (XmAuthentication)authentication;
            Set scope = Optional.ofNullable(xmAuthentication.getDetails()).map(XmAuthenticationDetails::getScope).orElse(Set.of());
            return Arrays.stream(scopes).anyMatch(scope::contains);
        }
        return false;
    }

    private static boolean hasAnyScopeMatching(Authentication authentication, String[] scopesRegex) {
        if (authentication instanceof XmAuthentication) {
            XmAuthentication xmAuthentication = (XmAuthentication)authentication;
            Set scopes = Optional.ofNullable(xmAuthentication.getDetails()).map(XmAuthenticationDetails::getScope).orElse(Set.of());
            for (String scope : scopes) {
                for (String regex : scopesRegex) {
                    if (!scope.matches(regex)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public AuthenticationSecurityExpressionMethods(Authentication authentication) {
        this.authentication = authentication;
    }
}

