/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.permission.service;

import com.google.common.base.CaseFormat;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.springframework.cglib.beans.BeanMap;
import tech.jhipster.service.filter.Filter;
import tech.jhipster.service.filter.RangeFilter;
import tech.jhipster.service.filter.StringFilter;

public class FilterConverter {
    public static <T> QueryPart toJpql(T criteria) {
        BeanMap.Generator gen = new BeanMap.Generator();
        gen.setBean(criteria);
        gen.setContextClass(criteria.getClass());
        BeanMap beanMap = gen.create();
        return FilterConverter.toJpql((Map<String, Filter>)beanMap);
    }

    private static QueryPart toJpql(Map<String, Filter> filterMap) {
        return filterMap.entrySet().stream().filter(s -> s.getValue() != null).flatMap(FilterConverter::resolveExpression).collect(QueryPart::new, QueryPart::accumulateExpression, QueryPart::combineQueryParts);
    }

    private static Stream<Expression> resolveExpression(Map.Entry<String, Filter> entry) {
        Stream.Builder<Expression> expressions = Stream.builder();
        Filter filter = entry.getValue();
        String fieldName = FilterConverter.preProcessForeignKeyFieldToJpql(entry.getKey());
        if (filter.getEquals() != null) {
            expressions.add(new Expression(fieldName, Operation.EQUALS, filter.getEquals()));
        }
        if (filter.getNotEquals() != null) {
            expressions.add(new Expression(fieldName, Operation.NOT_EQUALS, filter.getNotEquals()));
        }
        if (filter.getSpecified() != null) {
            Boolean specified = filter.getSpecified();
            expressions.add(new Expression(fieldName, specified != false ? Operation.SPECIFIED : Operation.NOT_SPECIFIED, specified));
        }
        if (filter.getIn() != null) {
            expressions.add(new Expression(fieldName, Operation.IN, filter.getIn()));
        }
        if (filter.getNotIn() != null) {
            expressions.add(new Expression(fieldName, Operation.NOT_IN, filter.getNotIn()));
        }
        if (filter instanceof StringFilter && ((StringFilter)filter).getContains() != null) {
            expressions.add(new Expression(fieldName, Operation.CONTAINS, ((StringFilter)filter).getContains()));
        }
        if (filter instanceof StringFilter && ((StringFilter)filter).getDoesNotContain() != null) {
            expressions.add(new Expression(fieldName, Operation.NOT_CONTAINS, ((StringFilter)filter).getDoesNotContain()));
        }
        if (filter instanceof RangeFilter) {
            RangeFilter rangeFilter = (RangeFilter)filter;
            if (rangeFilter.getGreaterThan() != null) {
                expressions.add(new Expression(fieldName, Operation.GREATER_THAN, rangeFilter.getGreaterThan()));
            }
            if (rangeFilter.getGreaterThanOrEqual() != null) {
                expressions.add(new Expression(fieldName, Operation.GREATER_OR_EQ_THAN, rangeFilter.getGreaterThanOrEqual()));
            }
            if (rangeFilter.getLessThan() != null) {
                expressions.add(new Expression(fieldName, Operation.LESS_THAN, rangeFilter.getLessThan()));
            }
            if (rangeFilter.getLessThanOrEqual() != null) {
                expressions.add(new Expression(fieldName, Operation.LESS_OR_EQ_THAN, rangeFilter.getLessThanOrEqual()));
            }
        }
        return expressions.build();
    }

    private static String preProcessForeignKeyField(String fieldName) {
        if (fieldName.endsWith("Id")) {
            return CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, fieldName);
        }
        return fieldName;
    }

    private static String preProcessForeignKeyFieldToJpql(String fieldName) {
        if (fieldName.endsWith("Id")) {
            return fieldName.substring(0, fieldName.length() - 2) + ".id";
        }
        return fieldName;
    }

    public static class QueryPart {
        public static final String JPQL_AND = " and ";
        StringBuilder query = new StringBuilder();
        Map<String, Object> params = new HashMap<String, Object>();
        Multiset<String> aliases = HashMultiset.create();

        public boolean isEmpty() {
            return this.query.length() == 0;
        }

        String getNextAliasName(String fieldName) {
            int cnt = this.aliases.count((Object)fieldName);
            this.aliases.add((Object)fieldName);
            return cnt == 0 ? fieldName : fieldName + cnt;
        }

        private static void accumulateExpression(QueryPart qp, Expression expression) {
            String paramAlias = QueryPart.cleanAliasName(qp.getNextAliasName(expression.getFieldName()));
            if (qp.isEmpty()) {
                qp.getQuery().append(expression.toJpql(paramAlias));
            } else {
                qp.getQuery().append(JPQL_AND).append(expression.toJpql(paramAlias));
            }
            if (expression.isOperationParamRequired()) {
                qp.getParams().put(paramAlias, expression.getValue());
            }
        }

        private static String cleanAliasName(String alias) {
            return alias.replaceAll("\\.", "_");
        }

        private static QueryPart combineQueryParts(QueryPart qp1, QueryPart qp2) {
            qp1.getQuery().append(JPQL_AND).append((CharSequence)qp2.getQuery());
            qp1.getParams().putAll(qp2.getParams());
            return qp1;
        }

        public StringBuilder getQuery() {
            return this.query;
        }

        public Map<String, Object> getParams() {
            return this.params;
        }

        public Multiset<String> getAliases() {
            return this.aliases;
        }

        public String toString() {
            return "FilterConverter.QueryPart(query=" + String.valueOf(this.getQuery()) + ", params=" + String.valueOf(this.getParams()) + ", aliases=" + String.valueOf(this.getAliases()) + ")";
        }
    }

    public static class Expression {
        public static final String JPQL_ALIAS_PREFIX = ":";
        String fieldName;
        Operation operation;
        Object value;

        boolean isOperationParamRequired() {
            return this.operation.isParamRequired();
        }

        String toJpql(String alias) {
            String jpql = this.fieldName + this.operation.getJpqlOp();
            if (this.operation.isParamRequired()) {
                jpql = jpql + JPQL_ALIAS_PREFIX + alias;
            }
            return jpql;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public Operation getOperation() {
            return this.operation;
        }

        public Object getValue() {
            return this.value;
        }

        public Expression(String fieldName, Operation operation, Object value) {
            this.fieldName = fieldName;
            this.operation = operation;
            this.value = value;
        }

        public String toString() {
            return "FilterConverter.Expression(fieldName=" + this.getFieldName() + ", operation=" + String.valueOf((Object)this.getOperation()) + ", value=" + String.valueOf(this.getValue()) + ")";
        }
    }

    public static enum Operation {
        EQUALS(" = ", true),
        NOT_EQUALS(" <> ", true),
        SPECIFIED(" is not null ", false),
        NOT_SPECIFIED(" is null ", false),
        IN(" in ", true),
        NOT_IN(" not in ", true),
        CONTAINS(" like ", true),
        NOT_CONTAINS(" not like ", true),
        GREATER_THAN(" > ", true),
        LESS_THAN(" < ", true),
        GREATER_OR_EQ_THAN(" >= ", true),
        LESS_OR_EQ_THAN(" <= ", true);

        private final String jpqlOp;
        private final boolean paramRequired;

        private Operation(String jpqlOp, boolean paramRequired) {
            this.jpqlOp = jpqlOp;
            this.paramRequired = paramRequired;
        }

        public String getJpqlOp() {
            return this.jpqlOp;
        }

        public boolean isParamRequired() {
            return this.paramRequired;
        }
    }
}

