/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.permission.service;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.icthh.xm.commons.config.client.utils.RequestUtils;
import com.icthh.xm.commons.exceptions.BusinessException;
import com.icthh.xm.commons.lep.api.LepAdditionalContext;
import com.icthh.xm.commons.lep.api.LepAdditionalContextField;
import com.icthh.xm.commons.logging.aop.IgnoreLogginAspect;
import com.icthh.xm.commons.permission.domain.dto.PermissionContextDto;
import java.net.URI;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class PermissionContextCheckService
implements LepAdditionalContext<PermissionContextCheckService> {
    private static final Logger log = LoggerFactory.getLogger(PermissionContextCheckService.class);
    private static final String API = "/api";
    @Value(value="${spring.application.name}")
    private String applicationName;
    @Value(value="${application.permission-context-uri:/uaa/api/account}")
    private String permissionContextUri;
    private final RestTemplate restTemplate;
    private final ObjectMapper objectMapper;

    public PermissionContextCheckService(@Qualifier(value="xm-config-rest-template") RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
        this.objectMapper = new ObjectMapper().configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false).registerModule((Module)new JavaTimeModule());
    }

    public boolean hasPermission(String permission) {
        return this.hasPermission(permission, Map.of());
    }

    public boolean hasPermission(String permission, Map<String, Object> expectedContextData) {
        PermissionContextDto contextDto = this.getPermissionContext();
        boolean isValidPermission = contextDto.getPermissions().contains(permission);
        boolean isValidContextDate = expectedContextData.entrySet().stream().allMatch(e -> {
            Map<String, Object> actual = contextDto.getCtx();
            return actual.containsKey(e.getKey()) && actual.get(e.getKey()).equals(e.getValue());
        });
        return isValidPermission && isValidContextDate;
    }

    private PermissionContextDto getPermissionContext() {
        log.info("Try to get permission context");
        try {
            HttpEntity request = new HttpEntity((MultiValueMap)RequestUtils.createAuthHeaders());
            URI uri = new URI("http://" + this.permissionContextUri);
            Map result = (Map)this.restTemplate.exchange(uri, HttpMethod.GET, request, Map.class).getBody();
            log.debug("Obtained permission context: {}", (Object)result);
            Map<String, PermissionContextDto> serviceContextMapping = this.writeContextAsMap(result.get("context"));
            return serviceContextMapping.get(this.applicationName);
        }
        catch (Exception ex) {
            log.error("Failed to fetch permission context from app {}: {}", (Object)this.applicationName, (Object)ex.getMessage());
            throw new BusinessException("error.permission.context.fetch", ex.getMessage());
        }
    }

    private Map<String, PermissionContextDto> writeContextAsMap(Object context) {
        return (Map)this.objectMapper.convertValue(context, (TypeReference)new TypeReference<TreeMap<String, PermissionContextDto>>(this){});
    }

    @IgnoreLogginAspect
    public String additionalContextKey() {
        return "permissionContextCheckService";
    }

    @IgnoreLogginAspect
    public PermissionContextCheckService additionalContextValue() {
        return this;
    }

    @IgnoreLogginAspect
    public Class<? extends LepAdditionalContextField> fieldAccessorInterface() {
        return PermissionContextCheckServiceField.class;
    }

    public static interface PermissionContextCheckServiceField
    extends LepAdditionalContextField {
        public static final String FIELD_NAME = "permissionContextCheckService";

        default public PermissionContextCheckService getPermissionContextCheckService() {
            return (PermissionContextCheckService)this.get(FIELD_NAME);
        }
    }
}

