/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.permission.service;

import com.icthh.xm.commons.config.client.api.RefreshableConfiguration;
import com.icthh.xm.commons.logging.aop.IgnoreLogginAspect;
import com.icthh.xm.commons.permission.config.PermissionProperties;
import com.icthh.xm.commons.permission.domain.Permission;
import com.icthh.xm.commons.permission.domain.mapper.PermissionMapper;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.AntPathMatcher;

@Service
@IgnoreLogginAspect
public class PermissionService
implements RefreshableConfiguration {
    private static final Logger log = LoggerFactory.getLogger(PermissionService.class);
    private static final String TENANT_NAME = "tenantName";
    private ConcurrentHashMap<String, Map<String, Permission>> permissions = new ConcurrentHashMap();
    private final AntPathMatcher matcher = new AntPathMatcher();
    private final PermissionProperties permissionProperties;
    @Value(value="${spring.application.name}")
    private String appName;

    public Map<String, Permission> getPermissions(String tenant) {
        if (!this.permissions.containsKey(tenant)) {
            return new HashMap<String, Permission>();
        }
        return this.permissions.get(tenant);
    }

    public void onRefresh(String key, String config) {
        try {
            String tenant = (String)this.matcher.extractUriTemplateVariables(this.permissionProperties.getPermissionsSpecPath(), key).get(TENANT_NAME);
            if (StringUtils.isBlank((CharSequence)config)) {
                this.permissions.remove(tenant);
                log.info("Permission specification for tenant {} was removed", (Object)tenant);
            } else {
                this.permissions.put(tenant, PermissionMapper.ymlToPermissions(config, this.appName));
                log.info("Permission specification for tenant {} was updated", (Object)tenant);
            }
        }
        catch (Exception e) {
            log.error("Error read permission specification from path " + key, (Throwable)e);
        }
    }

    public boolean isListeningConfiguration(String key) {
        return this.matcher.match(this.permissionProperties.getPermissionsSpecPath(), key);
    }

    public void onInit(String key, String config) {
        this.onRefresh(key, config);
    }

    public PermissionService(PermissionProperties permissionProperties) {
        this.permissionProperties = permissionProperties;
    }
}

