/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.permission.service.rolestrategy;

import com.icthh.xm.commons.exceptions.SkipPermissionException;
import com.icthh.xm.commons.permission.access.ResourceFactory;
import com.icthh.xm.commons.permission.access.subject.Subject;
import com.icthh.xm.commons.permission.domain.EnvironmentVariable;
import com.icthh.xm.commons.permission.domain.Permission;
import com.icthh.xm.commons.permission.domain.ReactionStrategy;
import com.icthh.xm.commons.permission.service.AuthenticationSecurityExpressionMethods;
import com.icthh.xm.commons.permission.service.PermissionEvaluationContextBuilder;
import com.icthh.xm.commons.permission.service.PermissionService;
import com.icthh.xm.commons.permission.service.RoleService;
import com.icthh.xm.commons.permission.service.rolestrategy.RoleStrategy;
import com.icthh.xm.commons.permission.service.translator.SpelTranslator;
import com.icthh.xm.commons.permission.utils.CollectionUtils;
import com.icthh.xm.commons.permission.utils.RequestHeaderUtils;
import com.icthh.xm.commons.security.XmAuthenticationContext;
import com.icthh.xm.commons.security.XmAuthenticationContextHolder;
import com.icthh.xm.commons.tenant.TenantContext;
import com.icthh.xm.commons.tenant.TenantContextHolder;
import com.icthh.xm.commons.tenant.TenantContextUtils;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.stereotype.Component;

@Component(value="multiRoleStrategy")
public class MultiRoleStrategy
implements RoleStrategy {
    private static final Logger log = LoggerFactory.getLogger(MultiRoleStrategy.class);
    private static final String LOG_KEY = "log";
    private final XmAuthenticationContextHolder xmAuthenticationContextHolder;
    private final TenantContextHolder tenantContextHolder;
    private final PermissionService permissionService;
    private final ResourceFactory resourceFactory;
    private final RoleService roleService;
    private final PermissionEvaluationContextBuilder permissionEvaluationContextBuilder;

    @Override
    public boolean hasPermission(Authentication authentication, Object privilege) {
        return this.checkRole(authentication, privilege, true) || this.checkPermission(authentication, null, privilege, false, true);
    }

    @Override
    public boolean hasPermission(Authentication authentication, Object resource, Object privilege) {
        boolean logPermission = MultiRoleStrategy.isLogPermission(resource);
        return this.checkRole(authentication, privilege, logPermission) || this.checkPermission(authentication, resource, privilege, true, logPermission);
    }

    @Override
    public boolean hasPermission(Authentication authentication, Serializable resource, String resourceType, Object privilege) {
        Object resourceId;
        boolean logPermission = MultiRoleStrategy.isLogPermission(resource);
        if (this.checkRole(authentication, privilege, logPermission)) {
            return true;
        }
        if (resource != null && (resourceId = ((Map)((Object)resource)).get("id")) != null) {
            ((Map)((Object)resource)).put(resourceType, this.resourceFactory.getResource(resourceId, resourceType));
        }
        return this.checkPermission(authentication, resource, privilege, true, logPermission);
    }

    @Override
    public String createCondition(Authentication authentication, Object privilegeKey, SpelTranslator translator) {
        if (!this.hasPermission(authentication, privilegeKey)) {
            throw new AccessDeniedException("Access is denied");
        }
        Collection<String> roleKeys = this.getRoleKeys(authentication);
        if (roleKeys.contains("SUPER-ADMIN")) {
            return "";
        }
        Map<String, Subject> subjects = this.getSubjects(roleKeys);
        Collection permissionsRoles = this.getPermissions(roleKeys, privilegeKey).stream().filter(permission -> Objects.nonNull(permission.getResourceCondition())).map(permission -> translator.translate(permission.getResourceCondition().getExpressionString(), (Subject)subjects.get(permission.getRoleKey()))).map(condition -> String.format("(%s)", condition)).collect(Collectors.toList());
        if (permissionsRoles.size() > 1) {
            return String.join((CharSequence)" OR ", permissionsRoles);
        }
        return permissionsRoles.stream().findAny().orElse("");
    }

    boolean checkPermission(Authentication authentication, Object resource, Object privilegeKey, boolean checkCondition, boolean logPermission) {
        Collection<String> roleKey = this.getRoleKeys(authentication);
        HashMap<String, Object> resources = new HashMap<String, Object>();
        if (resource != null) {
            resources.putAll((Map)resource);
        }
        resources.put("subject", this.getSubjects(roleKey).values());
        resources.put("oauth2", new AuthenticationSecurityExpressionMethods(authentication));
        HashMap<String, String> env = new HashMap<String, String>();
        env.put(EnvironmentVariable.IP.getName(), this.xmAuthenticationContextHolder.getContext().getRemoteAddress().orElse(null));
        resources.put("env", env);
        EvaluationContext context = this.permissionEvaluationContextBuilder.build(resources);
        Collection<Permission> permissions = this.getPermissions(roleKey, privilegeKey);
        if (!this.isPermissionEnabled(permissions)) {
            MultiRoleStrategy.log(logPermission, Level.ERROR, "access denied: privilege={}, role={}, userKey={} due to privilege is not permitted", privilegeKey, roleKey, this.getUserKey());
            return false;
        }
        boolean validCondition = true;
        if (!this.isConditionValid(permissions, context, Permission::getEnvCondition)) {
            MultiRoleStrategy.log(logPermission, Level.ERROR, "access denied: privilege={}, role={}, userKey={} due to env condition: {} with context [{}]", privilegeKey, roleKey, this.getUserKey(), permissions.stream().map(Permission::getEnvCondition).filter(Objects::nonNull).map(Expression::getExpressionString).collect(Collectors.toList()), resources);
            validCondition = false;
        }
        if (checkCondition && !this.isConditionValid(permissions, context, Permission::getResourceCondition)) {
            MultiRoleStrategy.log(logPermission, Level.ERROR, "access denied: privilege={}, role={}, userKey={} due to resource condition: {} with context [{}] ", privilegeKey, roleKey, this.getUserKey(), permissions.stream().map(Permission::getResourceCondition).filter(Objects::nonNull).map(Expression::getExpressionString).collect(Collectors.toList()), resources);
            validCondition = false;
        }
        List reactionStrategies = permissions.stream().map(Permission::getReactionStrategy).filter(Objects::nonNull).collect(Collectors.toList());
        if (!validCondition && reactionStrategies.contains((Object)ReactionStrategy.SKIP)) {
            throw new SkipPermissionException("Skip permission", (Collection)permissions.stream().map(permission -> permission.getRoleKey() + ":" + permission.getPrivilegeKey()).collect(Collectors.toList()));
        }
        if (!validCondition) {
            return false;
        }
        MultiRoleStrategy.log(logPermission, Level.INFO, "access granted: privilege={}, role={}, userKey={}", privilegeKey, roleKey, this.getUserKey());
        return true;
    }

    private boolean checkRole(Authentication authentication, Object privilege, boolean logPermission) {
        Collection<String> roleKeys = this.getRoleKeys(authentication);
        if (roleKeys.contains("SUPER-ADMIN")) {
            MultiRoleStrategy.log(logPermission, Level.INFO, "access granted: privilege={}, role=SUPER-ADMIN, userKey={}", privilege, this.getUserKey());
            return true;
        }
        if (CollectionUtils.listsNotEqualsIgnoreOrder(this.roleService.getRoles(TenantContextUtils.getRequiredTenantKeyValue((TenantContext)this.tenantContextHolder.getContext())).keySet(), roleKeys)) {
            MultiRoleStrategy.log(logPermission, Level.ERROR, "access denied: privilege={}, role={}, userKey={} due to role is missing", privilege, roleKeys, this.getUserKey());
            throw new AccessDeniedException("Access is denied");
        }
        return false;
    }

    private boolean isConditionValid(Collection<Permission> permissions, EvaluationContext context, Function<Permission, Expression> func) {
        return permissions.stream().anyMatch(permission -> {
            Expression expression = (Expression)func.apply((Permission)permission);
            if (Objects.isNull(expression) || StringUtils.isEmpty((CharSequence)expression.getExpressionString())) {
                return true;
            }
            try {
                return (Boolean)expression.getValue(context, Boolean.class);
            }
            catch (Exception e) {
                log.error("Exception while getting value ", (Throwable)e);
                return false;
            }
        });
    }

    private boolean isPermissionEnabled(Collection<Permission> permissions) {
        return permissions.stream().filter(Objects::nonNull).anyMatch(permission -> !permission.isDisabled());
    }

    Map<String, Subject> getSubjects(Collection<String> roleKeys) {
        XmAuthenticationContext authContext = this.xmAuthenticationContextHolder.getContext();
        return roleKeys.stream().collect(Collectors.toMap(roleKey -> roleKey, roleKey -> new Subject(authContext.getLogin().orElse(null), authContext.getUserKey().orElse(null), (String)roleKey)));
    }

    private String getUserKey() {
        return this.xmAuthenticationContextHolder.getContext().getUserKey().orElse(null);
    }

    Collection<String> getRoleKeys(Authentication authentication) {
        return authentication.getAuthorities().stream().map(GrantedAuthority::getAuthority).collect(Collectors.toList());
    }

    Collection<Permission> getPermissions(Collection<String> roleKeys, Object privilegeKey) {
        Map<String, Permission> permissions = this.permissionService.getPermissions(TenantContextUtils.getRequiredTenantKeyValue((TenantContext)this.tenantContextHolder.getContext()));
        List rolesPermissions = roleKeys.stream().map(roleKey -> (Permission)permissions.get(roleKey + ":" + String.valueOf(privilegeKey))).filter(Objects::nonNull).collect(Collectors.toList());
        return rolesPermissions.stream().collect(Collectors.groupingBy(Permission::getPrivilegeKey)).entrySet().stream().flatMap(this::toPermissions).collect(Collectors.toList());
    }

    private Stream<Permission> toPermissions(Map.Entry<String, List<Permission>> privilegeKeyPermissions) {
        Optional<Permission> permissionAllowsAll = privilegeKeyPermissions.getValue().stream().filter(permission -> Objects.isNull(permission.getResourceCondition())).filter(permission -> !permission.isDisabled()).findAny();
        if (permissionAllowsAll.isPresent()) {
            return permissionAllowsAll.stream();
        }
        return privilegeKeyPermissions.getValue().stream();
    }

    private static boolean isLogPermission(Object resource) {
        Map resourceMap;
        Object logFlag;
        if (resource != null && resource instanceof Map && (logFlag = (resourceMap = (Map)resource).get(LOG_KEY)) != null && logFlag instanceof Boolean) {
            resourceMap.remove(LOG_KEY);
            return (Boolean)logFlag;
        }
        return true;
    }

    private static void log(boolean allowToLog, Level logLevel, String logMessage, Object ... logArgs) {
        if (!allowToLog) {
            return;
        }
        switch (logLevel) {
            case INFO: {
                log.info(logMessage, logArgs);
                break;
            }
            case ERROR: {
                log.error(logMessage, logArgs);
                break;
            }
        }
    }

    private static Method lookupGetRequestHeaderMethod() {
        return RequestHeaderUtils.class.getDeclaredMethod("getRequestHeader", String.class);
    }

    public MultiRoleStrategy(XmAuthenticationContextHolder xmAuthenticationContextHolder, TenantContextHolder tenantContextHolder, PermissionService permissionService, ResourceFactory resourceFactory, RoleService roleService, PermissionEvaluationContextBuilder permissionEvaluationContextBuilder) {
        this.xmAuthenticationContextHolder = xmAuthenticationContextHolder;
        this.tenantContextHolder = tenantContextHolder;
        this.permissionService = permissionService;
        this.resourceFactory = resourceFactory;
        this.roleService = roleService;
        this.permissionEvaluationContextBuilder = permissionEvaluationContextBuilder;
    }
}

