/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.permission.service.rolestrategy;

import com.icthh.xm.commons.exceptions.SkipPermissionException;
import com.icthh.xm.commons.permission.access.ResourceFactory;
import com.icthh.xm.commons.permission.access.subject.Subject;
import com.icthh.xm.commons.permission.domain.EnvironmentVariable;
import com.icthh.xm.commons.permission.domain.Permission;
import com.icthh.xm.commons.permission.domain.ReactionStrategy;
import com.icthh.xm.commons.permission.service.AuthenticationSecurityExpressionMethods;
import com.icthh.xm.commons.permission.service.PermissionEvaluationContextBuilder;
import com.icthh.xm.commons.permission.service.PermissionService;
import com.icthh.xm.commons.permission.service.RoleService;
import com.icthh.xm.commons.permission.service.rolestrategy.RoleStrategy;
import com.icthh.xm.commons.permission.service.translator.SpelTranslator;
import com.icthh.xm.commons.security.XmAuthenticationContext;
import com.icthh.xm.commons.security.XmAuthenticationContextHolder;
import com.icthh.xm.commons.tenant.TenantContext;
import com.icthh.xm.commons.tenant.TenantContextHolder;
import com.icthh.xm.commons.tenant.TenantContextUtils;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.stereotype.Component;

@Component(value="singleRoleStrategy")
public class SingleRoleStrategy
implements RoleStrategy {
    private static final Logger log = LoggerFactory.getLogger(SingleRoleStrategy.class);
    private static final String ERROR_ROLE_IS_UNDEFINED = "Role is undefined";
    private static final String LOG_KEY = "log";
    private final XmAuthenticationContextHolder xmAuthenticationContextHolder;
    private final TenantContextHolder tenantContextHolder;
    private final PermissionService permissionService;
    private final ResourceFactory resourceFactory;
    private final RoleService roleService;
    private final PermissionEvaluationContextBuilder permissionEvaluationContextBuilder;

    @Override
    public boolean hasPermission(Authentication authentication, Object privilege) {
        return this.checkRole(authentication, privilege, true) || this.checkPermission(authentication, null, privilege, false, true);
    }

    @Override
    public boolean hasPermission(Authentication authentication, Object resource, Object privilege) {
        boolean logPermission = SingleRoleStrategy.isLogPermission(resource);
        return this.checkRole(authentication, privilege, logPermission) || this.checkPermission(authentication, resource, privilege, true, logPermission);
    }

    @Override
    public boolean hasPermission(Authentication authentication, Serializable resource, String resourceType, Object privilege) {
        Object resourceId;
        boolean logPermission = SingleRoleStrategy.isLogPermission(resource);
        if (this.checkRole(authentication, privilege, logPermission)) {
            return true;
        }
        if (resource != null && (resourceId = ((Map)((Object)resource)).get("id")) != null) {
            ((Map)((Object)resource)).put(resourceType, this.resourceFactory.getResource(resourceId, resourceType));
        }
        return this.checkPermission(authentication, resource, privilege, true, logPermission);
    }

    @Override
    public String createCondition(Authentication authentication, Object privilegeKey, SpelTranslator translator) {
        if (!this.hasPermission(authentication, privilegeKey)) {
            throw new AccessDeniedException("Access is denied");
        }
        String roleKey = SingleRoleStrategy.getRoleKey(authentication);
        Permission permission = this.getPermission(roleKey, privilegeKey);
        Subject subject = this.getSubject(roleKey);
        if (!"SUPER-ADMIN".equals(roleKey) && permission != null && permission.getResourceCondition() != null) {
            return String.format("(%s)", translator.translate(permission.getResourceCondition().getExpressionString(), subject));
        }
        return "";
    }

    private boolean checkPermission(Authentication authentication, Object resource, Object privilegeKey, boolean checkCondition, boolean logPermission) {
        String roleKey = SingleRoleStrategy.getRoleKey(authentication);
        HashMap<String, Object> resources = new HashMap<String, Object>();
        if (resource != null) {
            resources.putAll((Map)resource);
        }
        resources.put("subject", this.getSubject(roleKey));
        resources.put("oauth2", new AuthenticationSecurityExpressionMethods(authentication));
        HashMap<String, String> env = new HashMap<String, String>();
        env.put(EnvironmentVariable.IP.getName(), this.xmAuthenticationContextHolder.getContext().getRemoteAddress().orElse(null));
        resources.put("env", env);
        EvaluationContext context = this.permissionEvaluationContextBuilder.build(resources);
        Permission permission = this.getPermission(roleKey, privilegeKey);
        if (!SingleRoleStrategy.isPermissionValid(permission)) {
            SingleRoleStrategy.log(logPermission, Level.ERROR, "access denied: privilege={}, role={}, userKey={} due to privilege is not permitted", privilegeKey, roleKey, this.getUserKey());
            return false;
        }
        boolean validCondition = true;
        if (!SingleRoleStrategy.isConditionValid(permission.getEnvCondition(), context)) {
            SingleRoleStrategy.log(logPermission, Level.ERROR, "access denied: privilege={}, role={}, userKey={} due to env condition: [{}] with context [{}]", privilegeKey, roleKey, this.getUserKey(), permission.getEnvCondition().getExpressionString(), resources);
            validCondition = false;
        }
        if (checkCondition && !SingleRoleStrategy.isConditionValid(permission.getResourceCondition(), context)) {
            SingleRoleStrategy.log(logPermission, Level.ERROR, "access denied: privilege={}, role={}, userKey={} due to env condition: [{}] with context [{}] with context [{}]", privilegeKey, roleKey, this.getUserKey(), permission.getResourceCondition().getExpressionString(), resources);
            validCondition = false;
        }
        if (!validCondition && ReactionStrategy.SKIP.equals((Object)permission.getReactionStrategy())) {
            throw new SkipPermissionException("Skip permission", permission.getRoleKey() + ":" + permission.getPrivilegeKey());
        }
        if (!validCondition) {
            return false;
        }
        SingleRoleStrategy.log(logPermission, Level.INFO, "access granted: privilege={}, role={}, userKey={}", privilegeKey, roleKey, this.getUserKey());
        return true;
    }

    private boolean checkRole(Authentication authentication, Object privilege, boolean logPermission) {
        String roleKey = SingleRoleStrategy.getRoleKey(authentication);
        if ("SUPER-ADMIN".equals(roleKey)) {
            SingleRoleStrategy.log(logPermission, Level.INFO, "access granted: privilege={}, role=SUPER-ADMIN, userKey={}", privilege, this.getUserKey());
            return true;
        }
        if (!this.roleService.getRoles(TenantContextUtils.getRequiredTenantKeyValue((TenantContext)this.tenantContextHolder.getContext())).containsKey(roleKey)) {
            SingleRoleStrategy.log(logPermission, Level.ERROR, "access denied: privilege={}, role={}, userKey={} due to role is missing", privilege, roleKey, this.getUserKey());
            throw new AccessDeniedException("Access is denied");
        }
        return false;
    }

    private static boolean isConditionValid(Expression expression, EvaluationContext context) {
        boolean result;
        if (expression == null || StringUtils.isEmpty((CharSequence)expression.getExpressionString())) {
            result = true;
        } else {
            try {
                result = (Boolean)expression.getValue(context, Boolean.class);
            }
            catch (Exception e) {
                result = false;
                log.error("Exception while getting value ", (Throwable)e);
            }
        }
        return result;
    }

    private static boolean isPermissionValid(Permission permission) {
        boolean result = true;
        if (permission == null || permission.isDisabled()) {
            result = false;
        }
        return result;
    }

    private Subject getSubject(String roleKey) {
        XmAuthenticationContext authContext = this.xmAuthenticationContextHolder.getContext();
        return new Subject(authContext.getLogin().orElse(null), authContext.getUserKey().orElse(null), roleKey);
    }

    private String getUserKey() {
        return this.xmAuthenticationContextHolder.getContext().getUserKey().orElse(null);
    }

    private static String getRoleKey(Authentication authentication) {
        return ((GrantedAuthority)authentication.getAuthorities().stream().findFirst().orElseThrow(() -> new RuntimeException(ERROR_ROLE_IS_UNDEFINED))).getAuthority();
    }

    private Permission getPermission(String roleKey, Object privilegeKey) {
        return this.permissionService.getPermissions(TenantContextUtils.getRequiredTenantKeyValue((TenantContext)this.tenantContextHolder.getContext())).get(roleKey + ":" + String.valueOf(privilegeKey));
    }

    private static boolean isLogPermission(Object resource) {
        Map resourceMap;
        Object logFlag;
        if (resource != null && resource instanceof Map && (logFlag = (resourceMap = (Map)resource).get(LOG_KEY)) != null && logFlag instanceof Boolean) {
            resourceMap.remove(LOG_KEY);
            return (Boolean)logFlag;
        }
        return true;
    }

    private static void log(boolean allowToLog, Level logLevel, String logMessage, Object ... logArgs) {
        if (!allowToLog) {
            return;
        }
        switch (logLevel) {
            case INFO: {
                log.info(logMessage, logArgs);
                break;
            }
            case ERROR: {
                log.error(logMessage, logArgs);
                break;
            }
        }
    }

    public SingleRoleStrategy(XmAuthenticationContextHolder xmAuthenticationContextHolder, TenantContextHolder tenantContextHolder, PermissionService permissionService, ResourceFactory resourceFactory, RoleService roleService, PermissionEvaluationContextBuilder permissionEvaluationContextBuilder) {
        this.xmAuthenticationContextHolder = xmAuthenticationContextHolder;
        this.tenantContextHolder = tenantContextHolder;
        this.permissionService = permissionService;
        this.resourceFactory = resourceFactory;
        this.roleService = roleService;
        this.permissionEvaluationContextBuilder = permissionEvaluationContextBuilder;
    }
}

