/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.permission.web.rest;

import com.icthh.xm.commons.permission.annotation.PrivilegeDescription;
import com.icthh.xm.commons.permission.domain.dto.PermissionContextDto;
import com.icthh.xm.commons.permission.service.PermissionContextExposureService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/permission/context"})
public class PermissionContextResource {
    private static final Logger log = LoggerFactory.getLogger(PermissionContextResource.class);
    private final PermissionContextExposureService permissionContextExposureService;

    @GetMapping
    @PreAuthorize(value="hasPermission({'userKey': #userKey}, 'PERMISSION.CONTEXT.GET')")
    @PrivilegeDescription(value="Privilege to call get permission context")
    public ResponseEntity<PermissionContextDto> callGetFunction(@RequestParam String userKey) {
        PermissionContextDto context = this.permissionContextExposureService.exposePermissionContext(userKey);
        return ResponseEntity.ok().body((Object)context);
    }

    public PermissionContextResource(PermissionContextExposureService permissionContextExposureService) {
        this.permissionContextExposureService = permissionContextExposureService;
    }
}

