/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.permission.domain.mapper;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.icthh.xm.commons.permission.domain.Role;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RoleMapper {
    private static final Logger log = LoggerFactory.getLogger(RoleMapper.class);
    private static final ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());

    public static String rolesToYml(Collection<Role> roles) {
        try {
            TreeMap map = new TreeMap();
            roles.forEach(role -> map.put(role.getKey(), role));
            return mapper.writeValueAsString(map);
        }
        catch (Exception e) {
            log.error("Failed to create roles YML file from collection, error: {}", (Object)e.getMessage(), (Object)e);
            return null;
        }
    }

    public static Map<String, Role> ymlToRoles(String yml) {
        try {
            Map map = (Map)mapper.readValue(yml, (TypeReference)new TypeReference<TreeMap<String, Role>>(){});
            map.forEach((roleKey, role) -> role.setKey((String)roleKey));
            return map;
        }
        catch (Exception e) {
            log.error("Failed to create roles collection from YML file, error: {}", (Object)e.getMessage(), (Object)e);
            return Collections.emptyMap();
        }
    }

    private RoleMapper() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

