/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.permission.service;

import com.google.common.base.Preconditions;
import com.icthh.xm.commons.logging.aop.IgnoreLogginAspect;
import com.icthh.xm.commons.permission.domain.enums.IFeatureContext;
import com.icthh.xm.commons.permission.service.DynamicPermissionCheckService;
import com.icthh.xm.commons.permission.service.PermissionCheckService;
import com.icthh.xm.commons.permission.utils.SecurityUtils;
import com.icthh.xm.commons.security.XmAuthenticationContextHolder;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

public abstract class AbstractDynamicPermissionCheckService
implements DynamicPermissionCheckService {
    private static final Logger log = LoggerFactory.getLogger(AbstractDynamicPermissionCheckService.class);
    private final PermissionCheckService permissionCheckService;
    private final XmAuthenticationContextHolder xmAuthenticationContextHolder;

    @Override
    @IgnoreLogginAspect
    public boolean checkContextPermission(IFeatureContext featureContext, String basePermission, String suffix) {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)basePermission));
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)suffix));
        if (featureContext.isEnabled(this)) {
            return this.checkContextPermission(basePermission, suffix);
        }
        return this.assertPermission(basePermission);
    }

    private boolean checkContextPermission(String basePermission, String suffix) {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)basePermission));
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)suffix));
        String permission = basePermission + "." + suffix;
        return this.assertPermission(permission);
    }

    private boolean assertPermission(String permission) {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)permission));
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        boolean permitted = this.permissionCheckService.hasPermission(authentication, permission);
        if (!permitted) {
            String msg = String.format("access denied: privilege=%s, roleKey=%s, user=%s due to privilege is not permitted", permission, SecurityUtils.getRoleKeyOrNull(authentication), SecurityUtils.getUserKeyOrNull(this.xmAuthenticationContextHolder));
            throw new AccessDeniedException(msg);
        }
        return true;
    }

    public AbstractDynamicPermissionCheckService(PermissionCheckService permissionCheckService, XmAuthenticationContextHolder xmAuthenticationContextHolder) {
        this.permissionCheckService = permissionCheckService;
        this.xmAuthenticationContextHolder = xmAuthenticationContextHolder;
    }
}

