/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.permission.service;

import com.icthh.xm.commons.logging.aop.IgnoreLogginAspect;
import com.icthh.xm.commons.permission.service.rolestrategy.RoleStrategy;
import com.icthh.xm.commons.permission.service.translator.SpelTranslator;
import com.icthh.xm.commons.permission.utils.SecurityUtils;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;

@Service
@IgnoreLogginAspect
public class PermissionCheckService {
    private static final Logger log = LoggerFactory.getLogger(PermissionCheckService.class);
    private static final String MULTIROLE_FLAG_FIELD_NAME = "multiRoleEnabled";
    private final RoleStrategy multiRoleStrategy;
    private final RoleStrategy singleRoleStrategy;

    public PermissionCheckService(@Qualifier(value="multiRoleStrategy") RoleStrategy multiRoleStrategy, @Qualifier(value="singleRoleStrategy") RoleStrategy singleRoleStrategy) {
        this.multiRoleStrategy = multiRoleStrategy;
        this.singleRoleStrategy = singleRoleStrategy;
    }

    public boolean hasPermission(Authentication authentication, Object privilege) {
        return this.withStrategy(authentication).hasPermission(authentication, privilege);
    }

    public boolean hasPermission(Authentication authentication, Object resource, Object privilege) {
        return this.withStrategy(authentication).hasPermission(authentication, resource, privilege);
    }

    public boolean hasPermission(Authentication authentication, Serializable resource, String resourceType, Object privilege) {
        return this.withStrategy(authentication).hasPermission(authentication, resource, resourceType, privilege);
    }

    public String createCondition(Authentication authentication, Object privilegeKey, SpelTranslator translator) {
        return this.withStrategy(authentication).createCondition(authentication, privilegeKey, translator);
    }

    private RoleStrategy withStrategy(Authentication authentication) {
        return this.isMultiRoleEnabled(authentication) ? this.multiRoleStrategy : this.singleRoleStrategy;
    }

    boolean isMultiRoleEnabled(Authentication authentication) {
        try {
            return SecurityUtils.getAdditionalDetailsValueBoolean(authentication, MULTIROLE_FLAG_FIELD_NAME);
        }
        catch (Exception e) {
            log.error("Multi-role check failed, set multi-role as false, error: {}", (Object)e.getMessage(), (Object)e);
            return false;
        }
    }
}

