/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.permission.service.translator;

import com.icthh.xm.commons.permission.access.subject.Subject;
import com.icthh.xm.commons.permission.service.translator.SpelTranslator;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpelToJpqlTranslator
implements SpelTranslator {
    private static final Logger log = LoggerFactory.getLogger(SpelToJpqlTranslator.class);

    @Override
    public String translate(String spel, Subject subject) {
        if (StringUtils.isNotBlank((CharSequence)spel)) {
            String jpql = StringUtils.replaceAll((String)spel, (String)"#returnObject", (String)"returnObject");
            jpql = SpelToJpqlTranslator.replaceOperators(jpql);
            jpql = this.applySubject(jpql, subject);
            log.debug("SpEL was translated to JPQL for permission filtering: [{}] --> [{}]", (Object)spel, (Object)jpql);
            return jpql;
        }
        return spel;
    }

    private static String replaceOperators(String spel) {
        if (StringUtils.isBlank((CharSequence)spel)) {
            return spel;
        }
        return spel.replaceAll("==", " = ").replaceAll("&&", " and ").replaceAll("\\|\\|", " or ");
    }
}

