/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.permission.domain.mapper;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.icthh.xm.commons.permission.domain.Privilege;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PrivilegeMapper {
    private static final Logger log = LoggerFactory.getLogger(PrivilegeMapper.class);
    private static final ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());

    public static String privilegesToYml(Collection<Privilege> privileges) {
        try {
            TreeMap map = new TreeMap();
            privileges.forEach(privilege -> {
                map.putIfAbsent(privilege.getMsName(), new TreeSet());
                ((Set)map.get(privilege.getMsName())).add(privilege);
            });
            return mapper.writeValueAsString(map);
        }
        catch (Exception e) {
            log.error("Failed to create privileges YML file from collection, error: {}", (Object)e.getMessage(), (Object)e);
            return null;
        }
    }

    public static String privilegesMapToYml(Map<String, Collection<Privilege>> privileges) {
        try {
            return mapper.writeValueAsString(privileges);
        }
        catch (Exception e) {
            log.error("Failed to create privileges YML file from map, error: {}", (Object)e.getMessage(), (Object)e);
            return null;
        }
    }

    public static Map<String, Set<Privilege>> ymlToPrivileges(String yml) {
        try {
            TreeMap map = (TreeMap)mapper.readValue(yml, (TypeReference)new TypeReference<TreeMap<String, TreeSet<Privilege>>>(){});
            map.forEach((msName, privileges) -> privileges.forEach(privilege -> privilege.setMsName((String)msName)));
            return Collections.unmodifiableMap(map);
        }
        catch (Exception e) {
            log.error("Failed to create privileges collection from YML file, error: {}", (Object)e.getMessage(), (Object)e);
            return Collections.emptyMap();
        }
    }

    private PrivilegeMapper() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

