/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.permission.inspector.kafka;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.icthh.xm.commons.messaging.event.system.SystemEvent;
import com.icthh.xm.commons.permission.domain.Privilege;
import com.icthh.xm.commons.permission.domain.mapper.PrivilegeMapper;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.stereotype.Component;

@Component
public class PrivilegeEventProducer {
    private static final Logger log = LoggerFactory.getLogger(PrivilegeEventProducer.class);
    private final KafkaTemplate<String, String> template;
    private final ObjectMapper mapper = new ObjectMapper().configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false).setSerializationInclusion(JsonInclude.Include.NON_NULL).registerModule((Module)new JavaTimeModule());
    @Value(value="${spring.application.name}")
    private String appName;
    @Value(value="${application.kafka-system-queue:'system_queue'}")
    private String topicName;

    @Deprecated
    public void sendEvent(String eventId, String ymlPrivileges) {
        SystemEvent event = this.buildSystemEvent(eventId, ymlPrivileges);
        this.serializeEvent(event).ifPresent(this::send);
    }

    public void sendEvent(String eventId, Set<Privilege> privileges) {
        String ymlPrivileges = PrivilegeMapper.privilegesToYml(privileges);
        SystemEvent event = this.buildSystemEvent(eventId, ymlPrivileges);
        this.serializeEvent(event).ifPresent(this::send);
    }

    private Optional<String> serializeEvent(SystemEvent event) {
        try {
            return Optional.ofNullable(this.mapper.writeValueAsString((Object)event));
        }
        catch (JsonProcessingException e) {
            log.warn("Error while serializing system event: {}", (Object)event, (Object)e);
            return Optional.empty();
        }
    }

    private SystemEvent buildSystemEvent(String eventId, String ymlPrivileges) {
        SystemEvent event = new SystemEvent();
        event.setEventType("MS_PRIVILEGES");
        event.setEventId(eventId);
        event.setMessageSource(this.appName);
        event.setData(Collections.singletonMap("privileges", ymlPrivileges));
        return event;
    }

    private void send(String content) {
        if (!StringUtils.isBlank((CharSequence)content)) {
            log.info("Sending system queue event to kafka-topic = '{}', data = '{}'", (Object)this.topicName, (Object)content);
            this.template.send(this.topicName, (Object)content);
        }
    }

    public PrivilegeEventProducer(KafkaTemplate<String, String> template) {
        this.template = template;
    }
}

