/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.permission.service;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.icthh.xm.commons.logging.LoggingAspectConfig;
import com.icthh.xm.commons.permission.domain.Permission;
import com.icthh.xm.commons.permission.service.filter.PermissionMsNameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class PermissionMappingService {
    private static final Logger log = LoggerFactory.getLogger(PermissionMappingService.class);
    private final ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
    private final PermissionMsNameFilter permissionMsNameFilter;

    @LoggingAspectConfig(inputDetails=false, resultDetails=false)
    public Map<String, Permission> ymlToPermissions(String yml) {
        TreeMap result = new TreeMap();
        try {
            Map<String, ? extends Map<String, ? extends Set<Permission>>> permissionMap = this.deserializeYml(yml);
            permissionMap.entrySet().stream().filter(entry -> this.permissionMsNameFilter.filterPermission((String)entry.getKey())).filter(entry -> entry.getValue() != null).forEach(entry -> ((Map)entry.getValue()).forEach((roleKey, permissions) -> permissions.forEach(permission -> {
                permission.setMsName((String)entry.getKey());
                permission.setRoleKey((String)roleKey);
                result.put(roleKey + ":" + permission.getPrivilegeKey(), permission);
            })));
        }
        catch (Exception e) {
            log.error("Failed to create permissions collection from YML file, error: {}", (Object)e.getMessage(), (Object)e);
        }
        return Collections.unmodifiableMap(result);
    }

    @LoggingAspectConfig(inputDetails=false, resultDetails=false)
    public List<Permission> ymlToPermissionsList(String yml) {
        ArrayList result = new ArrayList();
        try {
            Map<String, ? extends Map<String, ? extends Set<Permission>>> map = this.deserializeYml(yml);
            map.entrySet().stream().filter(entry -> this.permissionMsNameFilter.filterPermission((String)entry.getKey())).filter(entry -> entry.getValue() != null).forEach(entry -> ((Map)entry.getValue()).forEach((roleKey, permissions) -> permissions.forEach(permission -> {
                permission.setMsName((String)entry.getKey());
                permission.setRoleKey((String)roleKey);
                result.add(permission);
            })));
        }
        catch (Exception e) {
            log.error("Failed to create permissions collection from YML file, error: {}", (Object)e.getMessage(), (Object)e);
        }
        return Collections.unmodifiableList(result);
    }

    private Map<String, ? extends Map<String, ? extends Set<Permission>>> deserializeYml(String yml) throws IOException {
        return (Map)this.mapper.readValue(yml, (TypeReference)new TypeReference<TreeMap<String, TreeMap<String, TreeSet<Permission>>>>(this){});
    }

    public PermissionMappingService(PermissionMsNameFilter permissionMsNameFilter) {
        this.permissionMsNameFilter = permissionMsNameFilter;
    }
}

