/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.permission.service.custom;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import com.icthh.xm.commons.config.client.api.refreshable.ConfigWithKey;
import com.icthh.xm.commons.config.client.repository.CommonConfigRepository;
import com.icthh.xm.commons.config.domain.Configuration;
import com.icthh.xm.commons.permission.service.custom.CustomPrivilegeSpecService;
import com.icthh.xm.commons.permission.service.custom.CustomPrivilegesExtractor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCustomPrivilegeSpecService
implements CustomPrivilegeSpecService {
    private static final Logger log = LoggerFactory.getLogger(AbstractCustomPrivilegeSpecService.class);
    private static final String TENANT_NAME = "tenantName";
    private static final String CUSTOMER_PRIVILEGES_PATH = "/config/tenants/{tenantName}/custom-privileges.yml";
    private final YAMLFactory yamlFactory = new YAMLFactory().enable(YAMLGenerator.Feature.USE_PLATFORM_LINE_BREAKS);
    private final ObjectMapper mapper = new ObjectMapper((JsonFactory)this.yamlFactory);
    private final CommonConfigRepository commonConfigRepository;
    private final List<CustomPrivilegesExtractor> privilegesExtractors;

    @Override
    public <S extends ConfigWithKey> void onSpecificationUpdate(Collection<S> specs, String tenantKey) {
        String privilegesPath = this.resolvePathWithTenant(tenantKey);
        Configuration customPrivilegesConfig = this.getConfigByPath(privilegesPath);
        this.updateCustomPrivileges(specs, privilegesPath, customPrivilegesConfig, tenantKey);
    }

    protected Configuration getConfigByPath(String privilegesPath) {
        log.info("Get custom-privileges actual config by path {}", (Object)privilegesPath);
        List<String> paths = List.of(privilegesPath);
        Map configs = this.commonConfigRepository.getConfig(null, paths);
        configs = configs == null ? new HashMap() : configs;
        return (Configuration)configs.get(privilegesPath);
    }

    private String resolvePathWithTenant(String tenantKey) {
        return CUSTOMER_PRIVILEGES_PATH.replace("{tenantName}", tenantKey);
    }

    protected <S extends ConfigWithKey> void updateCustomPrivileges(Collection<S> specs, String privilegesPath, Configuration customPrivileges, String tenantKey) {
        Map<String, List<Map<String, Object>>> privileges = this.readPrivilegesConfig(customPrivileges);
        this.addCustomPrivileges(specs, privileges, tenantKey);
        String content = this.mapper.writerWithDefaultPrettyPrinter().writeValueAsString(privileges);
        if (DigestUtils.sha1Hex((String)content).equals(this.sha1Hex(customPrivileges))) {
            log.info("Privileges configuration not changed y path: {}", (Object)privilegesPath);
            return;
        }
        this.commonConfigRepository.updateConfigFullPath(new Configuration(privilegesPath, content), this.sha1Hex(customPrivileges));
    }

    private <S extends ConfigWithKey> void addCustomPrivileges(Collection<S> specs, Map<String, List<Map<String, Object>>> privileges, String tenantKey) {
        HashMap customPrivileges = new HashMap();
        this.privilegesExtractors.stream().filter(extractor -> extractor.isEnabled(tenantKey)).forEach(extractor -> {
            List section = customPrivileges.computeIfAbsent(extractor.getSectionName(), k -> new ArrayList());
            section.addAll(extractor.toPrivileges(specs));
            section.sort(Comparator.comparing(it -> String.valueOf(it.get("key"))));
        });
        privileges.putAll(customPrivileges);
    }

    private Map<String, List<Map<String, Object>>> readPrivilegesConfig(Configuration customPrivileges) {
        if (this.isConfigExists(customPrivileges)) {
            return (Map)this.mapper.readValue(customPrivileges.getContent(), (TypeReference)new TypeReference<Map<String, List<Map<String, Object>>>>(this){});
        }
        return new HashMap<String, List<Map<String, Object>>>();
    }

    private String sha1Hex(Configuration configuration) {
        return Optional.ofNullable(configuration).map(Configuration::getContent).map(DigestUtils::sha1Hex).orElse(null);
    }

    private boolean isConfigExists(Configuration configuration) {
        return Optional.ofNullable(configuration).map(Configuration::getContent).map(StringUtils::isNotBlank).orElse(false);
    }

    public AbstractCustomPrivilegeSpecService(CommonConfigRepository commonConfigRepository, List<CustomPrivilegesExtractor> privilegesExtractors) {
        this.commonConfigRepository = commonConfigRepository;
        this.privilegesExtractors = privilegesExtractors;
    }
}

