/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.scheduler.metric;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricSet;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.springframework.stereotype.Component;

@Component
public class SchedulerMetricsSet
implements MetricSet {
    private final AtomicLong countSuccessMessages = new AtomicLong(0L);
    private final AtomicLong countFailedMessages = new AtomicLong(0L);
    private final AtomicReference<Instant> lastSuccess = new AtomicReference<Instant>(Instant.MIN);
    private final AtomicReference<Instant> lastError = new AtomicReference<Instant>(Instant.MIN);

    public Map<String, Metric> getMetrics() {
        HashMap<String, Metric> metrics = new HashMap<String, Metric>();
        metrics.put("success.messages.count", (Metric)((Gauge)this.countSuccessMessages::get));
        metrics.put("success.last.time", (Metric)((Gauge)() -> this.lastSuccess.get().toString()));
        metrics.put("failed.messages.count", (Metric)((Gauge)this.countFailedMessages::get));
        metrics.put("failed.last.time", (Metric)((Gauge)() -> this.lastError.get().toString()));
        return metrics;
    }

    public void onSuccess() {
        this.countSuccessMessages.incrementAndGet();
        this.lastSuccess.set(Instant.now());
    }

    public void onError() {
        this.countFailedMessages.incrementAndGet();
        this.lastError.set(Instant.now());
    }
}

