/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.scheduler.adapter;

import com.icthh.xm.commons.scheduler.service.SchedulerEventHandlerFacade;
import com.icthh.xm.commons.scheduler.service.SchedulerEventService;
import com.icthh.xm.commons.topic.domain.DynamicConsumer;
import com.icthh.xm.commons.topic.domain.TopicConfig;
import com.icthh.xm.commons.topic.message.MessageHandler;
import com.icthh.xm.commons.topic.service.AbstractDynamicConsumerConfiguration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationEventPublisher;

public class DynamicTopicConsumerConfiguration
extends AbstractDynamicConsumerConfiguration {
    private static final Logger log = LoggerFactory.getLogger(DynamicTopicConsumerConfiguration.class);
    private static final String PREFIX = "scheduler_";
    private static final String DELIMITER = "_";
    private static final String GENERAL_GROUP = "GENERALGROUP";
    private static final String TOPIC = "_topic";
    private static final String QUEUE = "_queue";
    private static final String AUTO_OFFSET_RESET_LATEST = "latest";
    private static final String AUTO_OFFSET_RESET_EARLIEST = "earliest";
    @Value(value="${spring.application.name}")
    private String appName;
    @Value(value="${application.scheduler-config.task-back-off-initial-interval:1000}")
    private long backOffInitialInterval;
    @Value(value="${application.scheduler-config.task-back-off-max-interval:60000}")
    private int backOffMaxInterval;
    @Value(value="${application.scheduler-config.build-topic-consumers:false}")
    private boolean buildTopicConsumers;
    @Value(value="${application.scheduler-config.build-multi-microservice-consumers:false}")
    private boolean buildMultiMicroserviceConsumers;
    @Value(value="${application.kafka-metadata-max-age:60000}")
    private int kafkaMetadataMaxAge;
    private final Map<String, List<DynamicConsumer>> dynamicConsumersByTenant = new ConcurrentHashMap<String, List<DynamicConsumer>>();
    private final SchedulerEventHandlerFacade schedulerEventHandlerFacade;

    public DynamicTopicConsumerConfiguration(SchedulerEventService schedulerEventService, ApplicationEventPublisher applicationEventPublisher) {
        super(applicationEventPublisher);
        this.schedulerEventHandlerFacade = new SchedulerEventHandlerFacade(schedulerEventService);
    }

    public List<DynamicConsumer> getDynamicConsumers(String tenantKey) {
        return this.dynamicConsumersByTenant.getOrDefault(this.getTenantMapKey(tenantKey), new ArrayList());
    }

    public void buildDynamicConsumers(String tenantName) {
        try {
            String tenant = StringUtils.lowerCase((String)tenantName);
            String tenantKey = StringUtils.upperCase((String)tenantName);
            String id = UUID.randomUUID().toString();
            this.createDynamicConsumer(PREFIX + tenant + DELIMITER + this.appName + QUEUE, this.appName, tenantKey, AUTO_OFFSET_RESET_EARLIEST);
            if (this.buildMultiMicroserviceConsumers) {
                this.createDynamicConsumer(PREFIX + tenant + QUEUE, GENERAL_GROUP, tenantKey, AUTO_OFFSET_RESET_EARLIEST);
                if (this.buildTopicConsumers) {
                    this.createDynamicConsumer(PREFIX + tenant + TOPIC, id, tenantKey, AUTO_OFFSET_RESET_LATEST);
                }
            }
            if (this.buildTopicConsumers) {
                this.createDynamicConsumer(PREFIX + tenant + DELIMITER + this.appName + TOPIC, id, tenantKey, AUTO_OFFSET_RESET_LATEST);
            }
        }
        catch (Exception e) {
            log.error("Error create scheduler channels for tenant " + tenantName, (Throwable)e);
            throw e;
        }
    }

    private void createDynamicConsumer(String chanelName, String consumerGroup, String tenantName, String startOffset) {
        DynamicConsumer dynamicConsumer = new DynamicConsumer();
        dynamicConsumer.setConfig(this.buildTopicConfig(chanelName, consumerGroup, startOffset));
        dynamicConsumer.setMessageHandler((MessageHandler)this.schedulerEventHandlerFacade);
        String tenantMapKey = this.getTenantMapKey(tenantName);
        this.dynamicConsumersByTenant.computeIfAbsent(tenantMapKey, v -> new ArrayList()).add(dynamicConsumer);
    }

    private TopicConfig buildTopicConfig(String chanelName, String consumerGroup, String startOffset) {
        TopicConfig topicConfig = new TopicConfig();
        topicConfig.setKey(chanelName);
        topicConfig.setTypeKey(chanelName);
        topicConfig.setTopicName(chanelName);
        topicConfig.setRetriesCount(Integer.valueOf(Integer.MAX_VALUE));
        topicConfig.setBackOffPeriod(Long.valueOf(this.backOffInitialInterval));
        topicConfig.setMaxPollInterval(Integer.valueOf(this.backOffMaxInterval));
        topicConfig.setGroupId(consumerGroup);
        topicConfig.setAutoOffsetReset(startOffset);
        topicConfig.setMetadataMaxAge(String.valueOf(this.kafkaMetadataMaxAge));
        return topicConfig;
    }

    private String getTenantMapKey(String tenantName) {
        return tenantName != null ? tenantName.toLowerCase() : null;
    }
}

