/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.scheduler.adapter;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.icthh.xm.commons.config.client.api.RefreshableConfiguration;
import com.icthh.xm.commons.config.client.config.XmConfigProperties;
import com.icthh.xm.commons.config.client.repository.TenantListRepository;
import com.icthh.xm.commons.config.domain.TenantState;
import com.icthh.xm.commons.scheduler.adapter.DynamicTopicConsumerConfiguration;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.event.EventListener;

public class SchedulerChannelManager
implements RefreshableConfiguration {
    private static final Logger log = LoggerFactory.getLogger(SchedulerChannelManager.class);
    private static final String SCHEDULER_APP_DEFAULT = "scheduler";
    private final DynamicTopicConsumerConfiguration dynamicTopicConsumerConfiguration;
    private final ObjectMapper objectMapper;
    @Value(value="${spring.application.name}")
    String appName;
    @Value(value="${application.scheduler-config.scheduler-app-name:scheduler}")
    private String schedulerAppName = "scheduler";
    private final Set<String> includedTenants;
    private volatile Set<String> tenantToStart;

    public SchedulerChannelManager(XmConfigProperties xmConfigProperties, DynamicTopicConsumerConfiguration dynamicTopicConsumerConfiguration) {
        this.includedTenants = xmConfigProperties.getIncludeTenantLowercase();
        this.dynamicTopicConsumerConfiguration = dynamicTopicConsumerConfiguration;
        this.objectMapper = new ObjectMapper();
    }

    boolean parseConfig(String key, String config) {
        Set tenantToStart;
        log.info("Tenants list was updated, start to parse config");
        if (!"/config/tenants/tenants-list.json".equals(key)) {
            throw new IllegalArgumentException("Wrong config key to update " + key);
        }
        if (StringUtils.isEmpty((CharSequence)config)) {
            throw new IllegalArgumentException("Config file has empty content: " + key);
        }
        Set tenantKeys = TenantListRepository.parseTenantStates((String)config, (ObjectMapper)this.objectMapper).getOrDefault(this.schedulerAppName, new HashSet());
        if (tenantKeys.isEmpty()) {
            log.warn("No one tenant configured to use scheduler. Add tenant state to ms-config/tenant-list.json to section $.scheduler");
        }
        if (!this.includedTenants.isEmpty()) {
            log.warn("Tenant list was overridden by property 'xm-config.include-tenants' to: {}", this.includedTenants);
        }
        if (Objects.equals(this.tenantToStart, tenantToStart = tenantKeys.stream().filter(TenantListRepository.isIncluded(this.includedTenants).and(TenantListRepository.isSuspended().negate())).map(TenantState::getName).collect(Collectors.toSet()))) {
            log.info("Tenants list was not changed old: {}, new: {}, skip update", this.tenantToStart, tenantToStart);
            return false;
        }
        this.tenantToStart = Set.copyOf(tenantToStart);
        log.info("scheduler will be turned on for tenants: {}", tenantToStart);
        return true;
    }

    @EventListener(value={ApplicationReadyEvent.class})
    public void startChannels() {
        if (this.tenantToStart == null) {
            throw new IllegalStateException("Scheduler channel manager was not initialized. Call onInit() first!");
        }
        log.info("Start channels for tenants: {}", this.tenantToStart);
        this.tenantToStart.forEach(tenantKey -> {
            this.dynamicTopicConsumerConfiguration.buildDynamicConsumers((String)tenantKey);
            this.dynamicTopicConsumerConfiguration.sendRefreshDynamicConsumersEvent((String)tenantKey);
        });
    }

    public void onRefresh(String key, String config) {
        if (this.parseConfig(key, config)) {
            this.startChannels();
        }
    }

    public boolean isListeningConfiguration(String updatedKey) {
        return "/config/tenants/tenants-list.json".equals(updatedKey);
    }

    public void onInit(String key, String config) {
        this.parseConfig(key, config);
    }
}

