/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.scheduler.service;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.icthh.xm.commons.logging.util.MdcUtils;
import com.icthh.xm.commons.scheduler.domain.ScheduledEvent;
import com.icthh.xm.commons.scheduler.service.SchedulerEventService;
import com.icthh.xm.commons.topic.domain.TopicConfig;
import com.icthh.xm.commons.topic.message.MessageHandler;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchedulerEventHandlerFacade
implements MessageHandler {
    private static final Logger log = LoggerFactory.getLogger(SchedulerEventHandlerFacade.class);
    private static final String WRAP_TOKEN = "\"";
    private final SchedulerEventService schedulerEventService;
    private final ObjectMapper objectMapper;

    public SchedulerEventHandlerFacade(SchedulerEventService schedulerEventService) {
        this.schedulerEventService = schedulerEventService;
        this.objectMapper = this.initObjectMapper();
    }

    public void onMessage(String message, String tenant, TopicConfig topicConfig) {
        try {
            MdcUtils.putRid((String)(MdcUtils.generateRid() + ":" + tenant));
            StopWatch stopWatch = StopWatch.createStarted();
            String payloadString = SchedulerEventHandlerFacade.unwrap(message);
            log.debug("start processing message for tenant: [{}], raw body in base64 = {}", (Object)tenant, (Object)payloadString);
            String eventBody = new String(Base64.getDecoder().decode(payloadString), StandardCharsets.UTF_8);
            log.info("start processing message for tenant: [{}], body = {}", (Object)tenant, (Object)eventBody);
            this.schedulerEventService.processSchedulerEvent(this.mapToEvent(eventBody), tenant);
            log.info("stop processing message for tenant: [{}], time = {}", (Object)tenant, (Object)stopWatch.getTime());
        }
        catch (Exception e) {
            log.error("error processing event for tenant [{}]", (Object)tenant, (Object)e);
            throw e;
        }
        finally {
            MdcUtils.clear();
        }
    }

    private ObjectMapper initObjectMapper() {
        return new ObjectMapper().registerModule((Module)new JavaTimeModule());
    }

    private ScheduledEvent mapToEvent(String eventBody) {
        return (ScheduledEvent)this.objectMapper.readValue(eventBody, ScheduledEvent.class);
    }

    public static String unwrap(String str) {
        if (StringUtils.isEmpty((CharSequence)str) || StringUtils.isEmpty((CharSequence)WRAP_TOKEN)) {
            return str;
        }
        if (StringUtils.startsWith((CharSequence)str, (CharSequence)WRAP_TOKEN) && StringUtils.endsWith((CharSequence)str, (CharSequence)WRAP_TOKEN)) {
            int startIndex = str.indexOf(WRAP_TOKEN);
            int endIndex = str.lastIndexOf(WRAP_TOKEN);
            int wrapLength = WRAP_TOKEN.length();
            if (startIndex != -1 && endIndex != -1) {
                return str.substring(startIndex + wrapLength, endIndex);
            }
        }
        return str;
    }
}

