/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.scheduler.service;

import com.icthh.xm.commons.scheduler.domain.ScheduledEvent;
import com.icthh.xm.commons.scheduler.service.SchedulerEventHandler;
import java.time.Instant;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SchedulerEventService {
    private static final Logger log = LoggerFactory.getLogger(SchedulerEventService.class);
    private final List<SchedulerEventHandler> handlers;

    public void processSchedulerEvent(ScheduledEvent event, String tenantKey) {
        if (event.getEndDate() != null && event.getEndDate().isBefore(Instant.now())) {
            log.warn("Event skipped because it expired. Event: {}", (Object)event);
            return;
        }
        if (this.handlers == null) {
            log.warn("No handlers found. Event: {} skipped.", (Object)event);
            return;
        }
        List<SchedulerEventHandler> eventHandlers = this.handlers.stream().filter(handler -> Objects.equals(handler.eventType(), event.getTypeKey()) || this.isHandlersForAll((SchedulerEventHandler)handler)).collect(Collectors.toList());
        if (eventHandlers.isEmpty()) {
            log.warn("No handlers found. Event: {} skipped.", (Object)event);
            return;
        }
        log.debug("Found {} handlers for event: {}", (Object)eventHandlers.size(), (Object)event);
        try {
            eventHandlers.forEach(handler -> handler.onEvent(event, tenantKey));
        }
        catch (Exception e) {
            log.error("Error process event {} error {}", (Object)event, (Object)e.getMessage());
            if (event.getEndDate() != null) {
                throw e;
            }
            log.info("End date in null. Error will be skipped.");
        }
    }

    private boolean isHandlersForAll(SchedulerEventHandler handler) {
        return "ALL".equals(handler.eventType());
    }

    public SchedulerEventService(List<SchedulerEventHandler> handlers) {
        this.handlers = handlers;
    }
}

