/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.scheduler.service;

import com.icthh.xm.commons.lep.api.LepEngineSession;
import com.icthh.xm.commons.lep.api.LepManagementService;
import com.icthh.xm.commons.scheduler.domain.ScheduledEvent;
import com.icthh.xm.commons.scheduler.metric.SchedulerMetricsSet;
import com.icthh.xm.commons.scheduler.service.SchedulerEventHandler;
import com.icthh.xm.commons.scheduler.service.SchedulerService;
import com.icthh.xm.commons.tenant.TenantContextHolder;
import com.icthh.xm.commons.tenant.TenantContextUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SchedulerHandler
implements SchedulerEventHandler {
    private static final Logger log = LoggerFactory.getLogger(SchedulerHandler.class);
    private final SchedulerService schedulerService;
    private final TenantContextHolder tenantContextHolder;
    private final LepManagementService lepManagementService;
    private final SchedulerMetricsSet schedulerMetricsSet;

    @Override
    public void onEvent(ScheduledEvent scheduledEvent, String tenant) {
        this.tenantContextHolder.getPrivilegedContext().execute(TenantContextUtils.buildTenant((String)tenant), () -> {
            try (LepEngineSession context = this.lepManagementService.beginThreadContext();){
                log.info("Receive event {} {}", (Object)scheduledEvent, (Object)tenant);
                this.schedulerService.onEvent(scheduledEvent);
                this.schedulerMetricsSet.onSuccess();
            }
            catch (Throwable e) {
                this.schedulerMetricsSet.onError();
                throw e;
            }
        });
    }

    public SchedulerHandler(SchedulerService schedulerService, TenantContextHolder tenantContextHolder, LepManagementService lepManagementService, SchedulerMetricsSet schedulerMetricsSet) {
        this.schedulerService = schedulerService;
        this.tenantContextHolder = tenantContextHolder;
        this.lepManagementService = lepManagementService;
        this.schedulerMetricsSet = schedulerMetricsSet;
    }
}

