/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.security.oauth2;

import com.icthh.xm.commons.security.oauth2.OAuth2Properties;
import com.icthh.xm.commons.security.oauth2.OAuth2SignatureVerifierClient;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.jwt.crypto.sign.SignatureVerifier;
import org.springframework.security.oauth2.common.exceptions.InvalidTokenException;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.token.store.JwtAccessTokenConverter;

public class OAuth2JwtAccessTokenConverter
extends JwtAccessTokenConverter {
    private final Logger log = LoggerFactory.getLogger(OAuth2JwtAccessTokenConverter.class);
    private final OAuth2Properties oAuth2Properties;
    private final OAuth2SignatureVerifierClient signatureVerifierClient;
    private volatile long lastKeyFetchTimestamp;

    public OAuth2JwtAccessTokenConverter(OAuth2Properties oAuth2Properties, OAuth2SignatureVerifierClient signatureVerifierClient) {
        this.oAuth2Properties = oAuth2Properties;
        this.signatureVerifierClient = signatureVerifierClient;
        this.tryCreateSignatureVerifier();
    }

    protected Map<String, Object> decode(String token) {
        try {
            long ttl = this.oAuth2Properties.getSignatureVerification().getTtl();
            if (ttl > 0L && System.currentTimeMillis() - this.lastKeyFetchTimestamp > ttl) {
                throw new InvalidTokenException("public key expired");
            }
            return super.decode(token);
        }
        catch (InvalidTokenException ex) {
            if (this.tryCreateSignatureVerifier()) {
                return super.decode(token);
            }
            throw ex;
        }
    }

    private boolean tryCreateSignatureVerifier() {
        long t = System.currentTimeMillis();
        if (t - this.lastKeyFetchTimestamp < this.oAuth2Properties.getSignatureVerification().getPublicKeyRefreshRateLimit()) {
            this.log.info("tryCreateSignatureVerifier: public key refresh limit reached");
            return false;
        }
        return this.createSignatureVerifier();
    }

    private synchronized boolean createSignatureVerifier() {
        try {
            SignatureVerifier verifier = this.signatureVerifierClient.getSignatureVerifier();
            if (verifier != null) {
                this.setVerifier(verifier);
                this.lastKeyFetchTimestamp = System.currentTimeMillis();
                this.log.debug("Public key retrieved from OAuth2 server to create SignatureVerifier");
                return true;
            }
        }
        catch (Throwable ex) {
            this.log.error("could not get public key from OAuth2 server to create SignatureVerifier", ex);
        }
        return false;
    }

    public OAuth2Authentication extractAuthentication(Map<String, ?> claims) {
        OAuth2Authentication authentication = super.extractAuthentication(claims);
        authentication.setDetails(claims);
        return authentication;
    }
}

