/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.tenantendpoint.provisioner;

import com.icthh.xm.commons.config.client.repository.TenantConfigRepository;
import com.icthh.xm.commons.config.domain.Configuration;
import com.icthh.xm.commons.gen.model.Tenant;
import com.icthh.xm.commons.tenantendpoint.provisioner.TenantProvisioner;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TenantConfigProvisioner
implements TenantProvisioner {
    private static final Logger log = LoggerFactory.getLogger(TenantConfigProvisioner.class);
    private List<Configuration> configurations;
    private final TenantConfigRepository tenantConfigRepository;

    public static String prependTenantPath(String path) {
        return FilenameUtils.separatorsToUnix((String)Paths.get("/config/tenants/{tenantName}/", path).toString());
    }

    @Override
    public void createTenant(Tenant tenant) {
        this.withConfigurations(tenant.getTenantKey(), () -> {
            String tenantKey = tenant.getTenantKey();
            this.tenantConfigRepository.createConfigsFullPath(tenantKey, this.configurations);
        });
    }

    @Override
    public void manageTenant(String tenantKey, String state) {
        log.info("Nothing to do with ms-config during manage tenant: {}, state = {}", (Object)tenantKey, (Object)state);
    }

    @Override
    public void deleteTenant(String tenantKey) {
        this.withConfigurations(tenantKey, () -> this.tenantConfigRepository.deleteConfigFullPath(tenantKey, "/api/config/tenants/{tenantName}/"));
    }

    public String toString() {
        return "TenantConfigProvisioner { configurations = " + this.configurations.stream().map(Configuration::getPath).collect(Collectors.toList()) + "}";
    }

    private void withConfigurations(String tenant, Runnable runnable) {
        if (this.configurations != null && !this.configurations.isEmpty()) {
            runnable.run();
        } else {
            log.warn("Skip ms-config provisioning as configuration list was not added. tenant: {}", (Object)tenant);
        }
    }

    public static TenantConfigProvisionerBuilder builder() {
        return new TenantConfigProvisionerBuilder();
    }

    public TenantConfigProvisioner(List<Configuration> configurations, TenantConfigRepository tenantConfigRepository) {
        this.configurations = configurations;
        this.tenantConfigRepository = tenantConfigRepository;
    }

    @Autowired
    public TenantConfigProvisioner(TenantConfigRepository tenantConfigRepository) {
        this.tenantConfigRepository = tenantConfigRepository;
    }

    public static class TenantConfigProvisionerBuilder {
        private ArrayList<Configuration> configurations;
        private TenantConfigRepository tenantConfigRepository;

        TenantConfigProvisionerBuilder() {
        }

        public TenantConfigProvisionerBuilder configuration(Configuration configuration) {
            if (this.configurations == null) {
                this.configurations = new ArrayList();
            }
            this.configurations.add(configuration);
            return this;
        }

        public TenantConfigProvisionerBuilder configurations(Collection<? extends Configuration> configurations) {
            if (this.configurations == null) {
                this.configurations = new ArrayList();
            }
            this.configurations.addAll(configurations);
            return this;
        }

        public TenantConfigProvisionerBuilder clearConfigurations() {
            if (this.configurations != null) {
                this.configurations.clear();
            }
            return this;
        }

        public TenantConfigProvisionerBuilder tenantConfigRepository(TenantConfigRepository tenantConfigRepository) {
            this.tenantConfigRepository = tenantConfigRepository;
            return this;
        }

        public TenantConfigProvisioner build() {
            List<Configuration> configurations;
            switch (this.configurations == null ? 0 : this.configurations.size()) {
                case 0: {
                    configurations = Collections.emptyList();
                    break;
                }
                case 1: {
                    configurations = Collections.singletonList(this.configurations.get(0));
                    break;
                }
                default: {
                    configurations = Collections.unmodifiableList(new ArrayList<Configuration>(this.configurations));
                }
            }
            return new TenantConfigProvisioner(configurations, this.tenantConfigRepository);
        }

        public String toString() {
            return "TenantConfigProvisioner.TenantConfigProvisionerBuilder(configurations=" + this.configurations + ", tenantConfigRepository=" + this.tenantConfigRepository + ")";
        }
    }
}

