/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.gen.api;

import com.icthh.xm.commons.gen.api.TenantsApi;
import com.icthh.xm.commons.gen.api.TenantsApiDelegate;
import com.icthh.xm.commons.gen.model.Tenant;
import io.swagger.annotations.ApiParam;
import java.util.List;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;

@Controller
public class TenantsApiController
implements TenantsApi {
    private final TenantsApiDelegate delegate;

    @Autowired
    public TenantsApiController(TenantsApiDelegate delegate) {
        this.delegate = delegate;
    }

    @Override
    public ResponseEntity<Void> addTenant(@ApiParam(value="Tenant object that needs to be added to the store", required=true) @Valid @RequestBody Tenant body) {
        return this.delegate.addTenant(body);
    }

    @Override
    public ResponseEntity<Void> deleteTenant(@ApiParam(value="Name of tenant to delete", required=true) @PathVariable(value="tenantKey") String tenantKey) {
        return this.delegate.deleteTenant(tenantKey);
    }

    @Override
    public ResponseEntity<List<Tenant>> getAllTenantInfo() {
        return this.delegate.getAllTenantInfo();
    }

    @Override
    public ResponseEntity<Tenant> getTenant(@ApiParam(value="Name of tenant to find", required=true) @PathVariable(value="tenantKey") String tenantKey) {
        return this.delegate.getTenant(tenantKey);
    }

    @Override
    public ResponseEntity<Void> manageTenant(@ApiParam(value="Name of tenant to manage", required=true) @PathVariable(value="tenantKey") String tenantKey, @ApiParam(value="Updated status for tenant", required=true) @Valid @RequestBody String body) {
        return this.delegate.manageTenant(tenantKey, body);
    }
}

