/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.tenantendpoint;

import com.icthh.xm.commons.exceptions.BusinessException;
import com.icthh.xm.commons.gen.model.Tenant;
import com.icthh.xm.commons.tenantendpoint.provisioner.TenantProvisioner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class TenantManager {
    private List<TenantProvisioner> services;
    private Consumer<? super Exception> exceptionHandler;

    public void createTenant(Tenant tenant) {
        this.withExceptionHandler(() -> this.services.forEach(tenantService -> tenantService.createTenant(tenant)));
    }

    public void manageTenant(String tenantKey, String state) {
        this.withExceptionHandler(() -> this.services.forEach(tenantService -> tenantService.manageTenant(tenantKey, state)));
    }

    public void deleteTenant(String tenantKey) {
        this.withExceptionHandler(() -> this.services.forEach(tenantService -> tenantService.deleteTenant(tenantKey)));
    }

    private void withExceptionHandler(Runnable action) {
        try {
            action.run();
        }
        catch (Exception e) {
            this.exceptionHandler.accept(e);
        }
    }

    private static <E extends Exception> Consumer<E> defaultExceptionHandler() {
        return e -> {
            if (e instanceof BusinessException) {
                throw (BusinessException)e;
            }
            throw new BusinessException(e.getMessage());
        };
    }

    public String toString() {
        return "TenantManager { services= " + this.services.stream().map(srv -> srv.getClass().getSimpleName()).collect(Collectors.toList()) + "}";
    }

    private static Consumer<? super Exception> $default$exceptionHandler() {
        return TenantManager.defaultExceptionHandler();
    }

    TenantManager(List<TenantProvisioner> services, Consumer<? super Exception> exceptionHandler) {
        this.services = services;
        this.exceptionHandler = exceptionHandler;
    }

    public static TenantManagerBuilder builder() {
        return new TenantManagerBuilder();
    }

    public static class TenantManagerBuilder {
        private ArrayList<TenantProvisioner> services;
        private boolean exceptionHandler$set;
        private Consumer<? super Exception> exceptionHandler$value;

        TenantManagerBuilder() {
        }

        public TenantManagerBuilder service(TenantProvisioner service) {
            if (this.services == null) {
                this.services = new ArrayList();
            }
            this.services.add(service);
            return this;
        }

        public TenantManagerBuilder services(Collection<? extends TenantProvisioner> services) {
            if (this.services == null) {
                this.services = new ArrayList();
            }
            this.services.addAll(services);
            return this;
        }

        public TenantManagerBuilder clearServices() {
            if (this.services != null) {
                this.services.clear();
            }
            return this;
        }

        public TenantManagerBuilder exceptionHandler(Consumer<? super Exception> exceptionHandler) {
            this.exceptionHandler$value = exceptionHandler;
            this.exceptionHandler$set = true;
            return this;
        }

        public TenantManager build() {
            List<TenantProvisioner> services;
            switch (this.services == null ? 0 : this.services.size()) {
                case 0: {
                    services = Collections.emptyList();
                    break;
                }
                case 1: {
                    services = Collections.singletonList(this.services.get(0));
                    break;
                }
                default: {
                    services = Collections.unmodifiableList(new ArrayList<TenantProvisioner>(this.services));
                }
            }
            Consumer<? super Exception> exceptionHandler$value = this.exceptionHandler$value;
            if (!this.exceptionHandler$set) {
                exceptionHandler$value = TenantManager.$default$exceptionHandler();
            }
            return new TenantManager(services, exceptionHandler$value);
        }

        public String toString() {
            return "TenantManager.TenantManagerBuilder(services=" + this.services + ", exceptionHandler$value=" + this.exceptionHandler$value + ")";
        }
    }
}

