/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.gen.api;

import com.icthh.xm.commons.gen.model.Tenant;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import jakarta.validation.Valid;
import java.util.List;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Validated
@Api(value="tenants", description="the tenants API")
@RequestMapping(value={"/api"})
public interface TenantsApi {
    @ApiOperation(value="Create tenant", nickname="addTenant", notes="", tags={"tenant"})
    @ApiResponses(value={@ApiResponse(code=200, message="Tenant create successful"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=403, message="Forbidden"), @ApiResponse(code=404, message="Not Found")})
    @RequestMapping(value={"/tenants"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<Void> addTenant(@ApiParam(value="Tenant object that needs to be added to the store", required=true) @Valid @RequestBody Tenant var1);

    @ApiOperation(value="Delete tenant by passed name", nickname="deleteTenant", notes="", tags={"tenant"})
    @ApiResponses(value={@ApiResponse(code=200, message="Tenant delete successful"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=403, message="Forbidden"), @ApiResponse(code=404, message="Not Found")})
    @RequestMapping(value={"/tenants/{tenantKey}"}, method={RequestMethod.DELETE})
    public ResponseEntity<Void> deleteTenant(@ApiParam(value="Name of tenant to delete", required=true) @PathVariable(value="tenantKey") String var1);

    @ApiOperation(value="Get all tenant info", nickname="getAllTenantInfo", notes="", response=Tenant.class, responseContainer="List", tags={"tenant"})
    @ApiResponses(value={@ApiResponse(code=200, message="successful operation", response=Tenant.class, responseContainer="List"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=403, message="Forbidden"), @ApiResponse(code=404, message="Not Found")})
    @RequestMapping(value={"/tenants"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<List<Tenant>> getAllTenantInfo();

    @ApiOperation(value="Get tenant info by name", nickname="getTenant", notes="Request return tenants info which find by passed tenants name", response=Tenant.class, tags={"tenant"})
    @ApiResponses(value={@ApiResponse(code=200, message="Tenant delete successful", response=Tenant.class), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=403, message="Forbidden"), @ApiResponse(code=404, message="Not Found")})
    @RequestMapping(value={"/tenants/{tenantKey}"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<Tenant> getTenant(@ApiParam(value="Name of tenant to find", required=true) @PathVariable(value="tenantKey") String var1);

    @ApiOperation(value="Tenant management", nickname="manageTenant", notes="Request for managing tenants info by passed tenant name", tags={"tenant"})
    @ApiResponses(value={@ApiResponse(code=200, message="Tenant changed successful"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=403, message="Forbidden"), @ApiResponse(code=404, message="Not Found")})
    @RequestMapping(value={"/tenants/{tenantKey}"}, consumes={"application/json"}, method={RequestMethod.PUT})
    public ResponseEntity<Void> manageTenant(@ApiParam(value="Name of tenant to manage", required=true) @PathVariable(value="tenantKey") String var1, @ApiParam(value="Updated status for tenant", required=true) @Valid @RequestBody String var2);
}

